/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.MapWriter;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.SymbolValueCountCollector;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.Hash;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;
import io.questdb.std.str.SingleCharCharSequence;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class SymbolMapWriter
implements Closeable,
MapWriter {
    public static final int HEADER_CACHE_ENABLED = 4;
    public static final int HEADER_CAPACITY = 0;
    public static final int HEADER_NULL_FLAG = 8;
    public static final int HEADER_SIZE = 64;
    private static final Log LOG = LogFactory.getLog(SymbolMapWriter.class);
    private final MemoryMARW charMem;
    private final BitmapIndexWriter indexWriter;
    private final SymbolValueCountCollector valueCountCollector;
    private CharSequenceIntHashMap cache;
    private boolean cachedFlag;
    private int maxHash;
    private boolean nullValue = false;
    private MemoryMARW offsetMem;
    private int symbolCapacity;
    private int symbolIndexInTxWriter;

    public SymbolMapWriter(CairoConfiguration configuration, Path path, CharSequence columnName, long columnNameTxn, int symbolCount, int symbolIndexInTxWriter, @NotNull SymbolValueCountCollector valueCountCollector) {
        int plen = path.size();
        try {
            FilesFacade ff = configuration.getFilesFacade();
            long mapPageSize = configuration.getSymbolTableAppendPageSize();
            if (!ff.exists(TableUtils.offsetFileName(path.trimTo(plen), columnName, columnNameTxn))) {
                LOG.error().$(path).$(" is not found").$();
                throw CairoException.fileNotFound().put("SymbolMap does not exist: ").put(path);
            }
            LPSZ lpsz = path.$();
            long len = ff.length(lpsz);
            if (len < 64L) {
                LOG.error().$(path).$(" is too short [len=").$(len).$(']').$();
                throw CairoException.critical(0).put("SymbolMap is too short: ").put(path);
            }
            this.offsetMem = Vm.getWholeMARWInstance(ff, lpsz, mapPageSize, 5, configuration.getWriterFileOpenOpts());
            this.symbolCapacity = this.offsetMem.getInt(0L);
            assert (this.symbolCapacity > 0);
            boolean useCache = this.offsetMem.getBool(4L);
            this.offsetMem.jumpTo(SymbolMapWriter.keyToOffset(symbolCount) + 8L);
            this.indexWriter = new BitmapIndexWriter(configuration);
            this.indexWriter.of(path.trimTo(plen), columnName, columnNameTxn);
            this.charMem = Vm.getWholeMARWInstance(ff, TableUtils.charFileName(path.trimTo(plen), columnName, columnNameTxn), mapPageSize, 5, configuration.getWriterFileOpenOpts());
            this.jumpCharMemToSymbolCount(symbolCount);
            this.maxHash = this.calculateMaxHashFromCapacity();
            this.setupCache(useCache);
            this.symbolIndexInTxWriter = symbolIndexInTxWriter;
            this.valueCountCollector = valueCountCollector;
            LOG.debug().$("open [columnName=").$(path.trimTo(plen).concat(columnName).$()).$(", fd=").$(this.offsetMem.getFd()).$(", cache=").$(this.cache != null).$(", capacity=").$(this.symbolCapacity).I$();
            this.indexWriter.rollbackValues(SymbolMapWriter.keyToOffset(symbolCount - 1));
        }
        catch (Throwable e) {
            this.closeNoTruncate();
            throw e;
        }
        finally {
            path.trimTo(plen);
        }
    }

    public static long keyToOffset(int key) {
        return 64L + (long)key * 8L;
    }

    public static void mergeSymbols(MapWriter dst, SymbolMapReader src, MemoryMARW map) {
        map.jumpTo(0L);
        int symbolCount = src.getSymbolCount();
        for (int srcId = 0; srcId < symbolCount; ++srcId) {
            map.putInt(dst.put(src.valueOf(srcId)));
        }
        dst.updateNullFlag(dst.getNullFlag() || src.containsNullValue());
    }

    public static boolean mergeSymbols(MapWriter dst, SymbolMapReader src) {
        boolean remapped = false;
        int symbolCount = src.getSymbolCount();
        for (int srcId = 0; srcId < symbolCount; ++srcId) {
            if (dst.put(src.valueOf(srcId)) == srcId) continue;
            remapped = true;
        }
        dst.updateNullFlag(dst.getNullFlag() || src.containsNullValue());
        return remapped;
    }

    @Override
    public void close() {
        Misc.free(this.indexWriter);
        Misc.free(this.charMem);
        if (this.offsetMem != null) {
            long fd = this.offsetMem.getFd();
            this.offsetMem = Misc.free(this.offsetMem);
            LOG.debug().$("closed [fd=").$(fd).$(']').$();
        }
        this.nullValue = false;
    }

    @Override
    public boolean getNullFlag() {
        return this.offsetMem.getBool(8L);
    }

    @Override
    public int getSymbolCapacity() {
        return this.symbolCapacity;
    }

    @Override
    public int getSymbolCount() {
        return SymbolMapWriter.offsetToKey(this.offsetMem.getAppendOffset() - 8L);
    }

    @Override
    public MemoryR getSymbolOffsetsMemory() {
        return this.offsetMem;
    }

    @Override
    public MemoryR getSymbolValuesMemory() {
        return this.charMem;
    }

    @Override
    public boolean isCached() {
        return this.cachedFlag;
    }

    @Override
    public int put(char c) {
        return this.put(SingleCharCharSequence.get(c));
    }

    @Override
    public int put(CharSequence symbol) {
        return this.put(symbol, this.valueCountCollector);
    }

    @Override
    public int put(CharSequence symbol, SymbolValueCountCollector valueCountCollector) {
        if (symbol == null) {
            if (!this.nullValue) {
                this.updateNullFlag(true);
            }
            return Integer.MIN_VALUE;
        }
        if (this.cache != null) {
            int index = this.cache.keyIndex(symbol);
            return index < 0 ? this.cache.valueAt(index) : this.lookupPutAndCache(index, symbol, valueCountCollector);
        }
        return this.lookupAndPut(symbol, valueCountCollector);
    }

    public void rebuildCapacity(CairoConfiguration configuration, Path path, CharSequence columnName, long columnNameTxn, int newCapacity, boolean newCacheFlag) {
        try {
            int plen = path.size();
            int symbolCount = this.getSymbolCount();
            FilesFacade ff = configuration.getFilesFacade();
            long mapPageSize = configuration.getMiscAppendPageSize();
            this.symbolCapacity = newCapacity;
            assert (this.symbolCapacity > 0);
            this.offsetMem.smallFile(ff, BitmapIndexUtils.keyFileName(path.trimTo(plen), columnName, columnNameTxn), 5);
            BitmapIndexWriter.initKeyMemory(this.offsetMem, TableUtils.MIN_INDEX_VALUE_BLOCK_SIZE);
            ff.touch(BitmapIndexUtils.valueFileName(path.trimTo(plen), columnName, columnNameTxn));
            this.indexWriter.of(path.trimTo(plen), columnName, columnNameTxn);
            if (!ff.exists(TableUtils.offsetFileName(path.trimTo(plen), columnName, columnNameTxn))) {
                LOG.error().$(path).$(" is not found").$();
                throw CairoException.fileNotFound().put("SymbolMap does not exist: ").put(path);
            }
            LPSZ lpsz = path.$();
            long len = ff.length(lpsz);
            if (len < 64L) {
                LOG.error().$(path).$(" is too short [len=").$(len).$(']').$();
                throw CairoException.critical(0).put("SymbolMap is too short [path=").put(path).put(", expected=").put(64L).put(", actual=").put(len).put(']');
            }
            this.offsetMem.of(ff, lpsz, mapPageSize, 5, configuration.getWriterFileOpenOpts());
            this.offsetMem.putInt(0L, this.symbolCapacity);
            this.offsetMem.jumpTo(SymbolMapWriter.keyToOffset(symbolCount) + 8L);
            this.charMem.of(ff, TableUtils.charFileName(path.trimTo(plen), columnName, columnNameTxn), mapPageSize, 5, configuration.getWriterFileOpenOpts());
            this.jumpCharMemToSymbolCount(symbolCount);
            this.maxHash = this.calculateMaxHashFromCapacity();
            if (newCacheFlag != this.cachedFlag) {
                this.setupCache(newCacheFlag);
            }
            LOG.debug().$("open [columnName=").$(path.trimTo(plen).concat(columnName).$()).$(", fd=").$(this.offsetMem.getFd()).$(", cache=").$(this.cache != null).$(", capacity=").$(this.symbolCapacity).I$();
            for (int i = 0; i < symbolCount; ++i) {
                long offset = SymbolMapWriter.keyToOffset(i);
                long strOffset = this.offsetMem.getLong(offset);
                CharSequence symbol = this.charMem.getStrA(strOffset);
                int hash = Hash.boundedHash(symbol, this.maxHash);
                this.indexWriter.add(hash, offset);
            }
        }
        catch (Throwable th) {
            this.closeNoTruncate();
            throw th;
        }
    }

    @Override
    public void rollback(int symbolCount) {
        try {
            this.indexWriter.rollbackValues(SymbolMapWriter.keyToOffset(symbolCount - 1));
            this.offsetMem.jumpTo(SymbolMapWriter.keyToOffset(symbolCount) + 8L);
            this.valueCountCollector.collectValueCount(this.symbolIndexInTxWriter, symbolCount);
            Misc.clear(this.cache);
            this.jumpCharMemToSymbolCount(symbolCount);
        }
        catch (Throwable th) {
            this.closeNoTruncate();
            throw th;
        }
    }

    @Override
    public void setSymbolIndexInTxWriter(int symbolIndexInTxWriter) {
        this.symbolIndexInTxWriter = symbolIndexInTxWriter;
    }

    @Override
    public void sync(boolean async) {
        this.charMem.sync(async);
        this.offsetMem.sync(async);
        this.indexWriter.sync(async);
    }

    @Override
    public void truncate() {
        int symbolCapacity = this.offsetMem.getInt(0L);
        this.offsetMem.truncate();
        this.offsetMem.putInt(0L, symbolCapacity);
        this.offsetMem.putBool(4L, this.isCached());
        this.updateNullFlag(false);
        this.offsetMem.jumpTo(SymbolMapWriter.keyToOffset(0) + 8L);
        this.charMem.truncate();
        this.indexWriter.truncate();
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    @Override
    public void updateCacheFlag(boolean flag) {
        this.offsetMem.putBool(4L, flag);
        this.cachedFlag = flag;
    }

    @Override
    public void updateNullFlag(boolean flag) {
        this.offsetMem.putBool(8L, flag);
        this.nullValue = flag;
    }

    private int calculateMaxHashFromCapacity() {
        return Math.max(Numbers.ceilPow2(this.symbolCapacity / 2) - 1, 1);
    }

    private void closeNoTruncate() {
        if (this.charMem != null) {
            this.charMem.close(false);
        }
        if (this.offsetMem != null) {
            this.offsetMem.close(false);
        }
        if (this.indexWriter != null) {
            this.indexWriter.closeNoTruncate();
        }
    }

    private void jumpCharMemToSymbolCount(int symbolCount) {
        if (symbolCount > 0) {
            long minExpectedSize;
            long cFileSize = this.offsetMem.getLong(SymbolMapWriter.keyToOffset(symbolCount));
            if (cFileSize < (minExpectedSize = (long)symbolCount * Vm.getStorageLength(1) - 2L)) {
                throw CairoException.nonCritical().put("symbol column map is corrupt, offsetFileLastOffset=").put(cFileSize).put(", symbolCount=").put(symbolCount).put(", expectedMin=").put(minExpectedSize).put(']');
            }
            this.charMem.jumpTo(cFileSize);
        } else {
            this.charMem.jumpTo(0L);
        }
    }

    private int lookupAndPut(CharSequence symbol, SymbolValueCountCollector countCollector) {
        int hash = Hash.boundedHash(symbol, this.maxHash);
        RowCursor cursor = this.indexWriter.getCursor(hash);
        while (cursor.hasNext()) {
            long offsetOffset = cursor.next();
            if (!Chars.equals(symbol, this.charMem.getStrA(this.offsetMem.getLong(offsetOffset)))) continue;
            return SymbolMapWriter.offsetToKey(offsetOffset);
        }
        return this.put0(symbol, hash, countCollector);
    }

    private int lookupPutAndCache(int index, CharSequence symbol, SymbolValueCountCollector countCollector) {
        int result = this.lookupAndPut(symbol, countCollector);
        this.cache.putAt(index, symbol.toString(), result);
        return result;
    }

    private int put0(CharSequence symbol, int hash, SymbolValueCountCollector countCollector) {
        long nOffsetOffset = this.offsetMem.getAppendOffset() - 8L;
        long nPlusOneValue = this.charMem.putStr(symbol);
        this.indexWriter.add(hash, nOffsetOffset);
        this.offsetMem.putLong(nPlusOneValue);
        int symIndex = SymbolMapWriter.offsetToKey(nOffsetOffset);
        countCollector.collectValueCount(this.symbolIndexInTxWriter, symIndex + 1);
        return symIndex;
    }

    private void setupCache(boolean newCacheFlag) {
        if (newCacheFlag) {
            this.cache = new CharSequenceIntHashMap(this.symbolCapacity, 0.3, -1);
            this.cachedFlag = true;
        } else {
            this.cache = null;
            this.cachedFlag = false;
        }
    }

    static int offsetToKey(long offset) {
        return (int)((offset - 64L) / 8L);
    }
}

