/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.cutlass.http.client.HttpClientCookieHandlerFactory;
import io.questdb.network.EpollFacade;
import io.questdb.network.EpollFacadeImpl;
import io.questdb.network.KqueueFacade;
import io.questdb.network.KqueueFacadeImpl;
import io.questdb.network.NetworkFacade;
import io.questdb.network.NetworkFacadeImpl;
import io.questdb.network.SelectFacade;
import io.questdb.network.SelectFacadeImpl;

public interface HttpClientConfiguration {
    default public boolean fixBrokenConnection() {
        return true;
    }

    public HttpClientCookieHandlerFactory getCookieHandlerFactory();

    default public EpollFacade getEpollFacade() {
        return EpollFacadeImpl.INSTANCE;
    }

    default public int getInitialRequestBufferSize() {
        return Math.min(65536, this.getMaximumRequestBufferSize());
    }

    default public KqueueFacade getKQueueFacade() {
        return KqueueFacadeImpl.INSTANCE;
    }

    default public int getMaximumRequestBufferSize() {
        return Integer.MAX_VALUE;
    }

    default public NetworkFacade getNetworkFacade() {
        return NetworkFacadeImpl.INSTANCE;
    }

    default public int getResponseBufferSize() {
        return 65536;
    }

    default public SelectFacade getSelectFacade() {
        return SelectFacadeImpl.INSTANCE;
    }

    default public String getSettingsPath() {
        return "/settings";
    }

    default public int getTimeout() {
        return 60000;
    }

    default public int getWaitQueueCapacity() {
        return 4;
    }
}

