/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.common.entity.manager.Bulletin;
import org.apache.hertzbeat.common.entity.manager.Monitor;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.manager.dao.BulletinDao;
import org.apache.hertzbeat.manager.pojo.dto.BulletinMetricsData;
import org.apache.hertzbeat.manager.service.BulletinService;
import org.apache.hertzbeat.manager.service.MonitorService;
import org.apache.hertzbeat.warehouse.store.realtime.RealTimeDataReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class BulletinServiceImpl
implements BulletinService {
    private static final Logger log = LoggerFactory.getLogger(BulletinServiceImpl.class);
    private static final String NO_DATA = "No Data";
    private static final String EMPTY_STRING = "";
    @Autowired
    private BulletinDao bulletinDao;
    @Autowired
    private MonitorService monitorService;
    @Autowired
    private RealTimeDataReader realTimeDataReader;

    @Override
    public void validate(Bulletin bulletin) throws IllegalArgumentException {
        if (bulletin == null) {
            throw new IllegalArgumentException("Bulletin cannot be null");
        }
        if (bulletin.getApp() == null || bulletin.getApp().isEmpty()) {
            throw new IllegalArgumentException("Bulletin app cannot be null or empty");
        }
        if (bulletin.getFields() == null || bulletin.getFields().isEmpty()) {
            throw new IllegalArgumentException("Bulletin fields cannot be null or empty");
        }
        if (bulletin.getMonitorIds() == null || bulletin.getMonitorIds().isEmpty()) {
            throw new IllegalArgumentException("Bulletin monitorIds cannot be null or empty");
        }
        if (this.bulletinDao.countByName(bulletin.getName()) > 0) {
            throw new IllegalArgumentException("Bulletin name duplicated");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void editBulletin(Bulletin bulletin) {
        Optional optional = this.bulletinDao.findById(bulletin.getId());
        if (optional.isEmpty()) {
            throw new IllegalArgumentException("Bulletin not found");
        }
        this.bulletinDao.save(bulletin);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addBulletin(Bulletin bulletin) {
        this.bulletinDao.save(bulletin);
    }

    @Override
    public BulletinMetricsData buildBulletinMetricsData(Long id) {
        Optional optional = this.bulletinDao.findById(id);
        if (optional.isEmpty()) {
            throw new IllegalArgumentException("Bulletin not found");
        }
        Bulletin bulletin = (Bulletin)optional.get();
        BulletinMetricsData.BulletinMetricsDataBuilder contentBuilder = BulletinMetricsData.builder().name(bulletin.getName());
        ArrayList<BulletinMetricsData.Data> dataList = new ArrayList<BulletinMetricsData.Data>();
        for (Long monitorId : bulletin.getMonitorIds()) {
            Monitor monitor = this.monitorService.getMonitor(monitorId);
            if (null == monitor) continue;
            BulletinMetricsData.Data.DataBuilder dataBuilder = BulletinMetricsData.Data.builder().monitorId(monitorId).monitorName(monitor.getName()).host(monitor.getInstance());
            ArrayList<BulletinMetricsData.Metric> metrics = new ArrayList<BulletinMetricsData.Metric>();
            Map fieldMap = bulletin.getFields();
            if (fieldMap != null) {
                for (Map.Entry entry : fieldMap.entrySet()) {
                    String metric = (String)entry.getKey();
                    List fields = (List)entry.getValue();
                    BulletinMetricsData.Metric.MetricBuilder metricBuilder = BulletinMetricsData.Metric.builder().name(metric);
                    CollectRep.MetricsData currentMetricsData = this.realTimeDataReader.getCurrentMetricsData(monitorId, metric);
                    List<List<BulletinMetricsData.Field>> fieldsList = currentMetricsData != null ? currentMetricsData.getValues().stream().map(valueRow -> {
                        List<BulletinMetricsData.Field> fieldList = currentMetricsData.getFields().stream().map(field -> BulletinMetricsData.Field.builder().key(field.getName()).unit(field.getUnit()).build()).toList();
                        for (int i = 0; i < fieldList.size(); ++i) {
                            fieldList.get(i).setValue(valueRow.getColumns(i));
                        }
                        return fieldList.stream().filter(field -> fields.contains(field.getKey())).toList();
                    }).toList() : Collections.singletonList(fields.stream().map(field -> BulletinMetricsData.Field.builder().key((String)field).unit(EMPTY_STRING).value(NO_DATA).build()).toList());
                    metricBuilder.fields(fieldsList);
                    metrics.add(metricBuilder.build());
                }
            }
            dataBuilder.metrics(metrics);
            dataList.add(dataBuilder.build());
        }
        contentBuilder.content(dataList);
        return contentBuilder.build();
    }

    @Override
    public Page<Bulletin> getBulletins(String search, Integer pageIndex, Integer pageSize) {
        pageIndex = pageIndex == null ? 0 : pageIndex;
        pageSize = pageSize == null ? Integer.MAX_VALUE : pageSize;
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            Predicate predicate = criteriaBuilder.conjunction();
            if (StringUtils.isNotBlank((CharSequence)search)) {
                Predicate predicateName = criteriaBuilder.like((Expression)root.get("name"), "%" + search + "%");
                predicate = criteriaBuilder.and(new Predicate[]{predicateName});
            }
            return predicate;
        };
        PageRequest pageRequest = PageRequest.of((int)pageIndex, (int)pageSize);
        return this.bulletinDao.findAll(specification, (Pageable)pageRequest);
    }

    @Override
    public void deleteBulletins(List<Long> ids) {
        this.bulletinDao.deleteAllById(ids);
    }

    @Override
    public Optional<Bulletin> getBulletinById(Long id) {
        return this.bulletinDao.findById(id);
    }
}

