/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.controller;

import com.usthe.sureness.subject.SubjectSum;
import com.usthe.sureness.util.SurenessContextHolder;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Set;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.manager.service.MetricsFavoriteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Metrics Favorite API")
@RestController
@RequestMapping(path={"/api/metrics/favorite"})
public class MetricsFavoriteController {
    private static final Logger log = LoggerFactory.getLogger(MetricsFavoriteController.class);
    private final MetricsFavoriteService metricsFavoriteService;

    @PostMapping(value={"/{monitorId}/{metricsName}"})
    @Operation(summary="Add metrics to favorites", description="Add specific metrics to user's favorites")
    public ResponseEntity<Message<Void>> addMetricsFavorite(@Parameter(description="Monitor ID", example="6565463543") @PathVariable Long monitorId, @Parameter(description="Metrics name", example="cpu") @PathVariable String metricsName) {
        String user = this.getCurrentUser();
        if (user == null) {
            return ResponseEntity.ok((Object)Message.fail((byte)5, (String)"User not authenticated"));
        }
        this.metricsFavoriteService.addMetricsFavorite(user, monitorId, metricsName);
        return ResponseEntity.ok((Object)Message.success((String)"Metrics added to favorites successfully"));
    }

    @DeleteMapping(value={"/{monitorId}/{metricsName}"})
    @Operation(summary="Remove metrics from favorites", description="Remove specific metrics from user's favorites")
    public ResponseEntity<Message<Void>> removeMetricsFavorite(@Parameter(description="Monitor ID", example="6565463543") @PathVariable Long monitorId, @Parameter(description="Metrics name", example="cpu") @PathVariable String metricsName) {
        String user = this.getCurrentUser();
        if (user == null) {
            return ResponseEntity.ok((Object)Message.fail((byte)5, (String)"User not authenticated"));
        }
        this.metricsFavoriteService.removeMetricsFavorite(user, monitorId, metricsName);
        return ResponseEntity.ok((Object)Message.success((String)"Metrics removed from favorites successfully"));
    }

    @GetMapping(value={"/{monitorId}"})
    @Operation(summary="Get user's all favorited metrics", description="Get all favorited metrics for current user")
    public ResponseEntity<Message<Set<String>>> getUserFavoritedMetrics(@Parameter(description="Monitor ID", example="6565463543") @PathVariable Long monitorId) {
        String user = this.getCurrentUser();
        if (user == null) {
            return ResponseEntity.ok((Object)Message.fail((byte)5, (String)"User not authenticated"));
        }
        Set<String> favoritedMetrics = this.metricsFavoriteService.getUserFavoritedMetrics(user, monitorId);
        return ResponseEntity.ok((Object)Message.success(favoritedMetrics));
    }

    private String getCurrentUser() {
        try {
            SubjectSum subjectSum = SurenessContextHolder.getBindSubject();
            return String.valueOf(subjectSum.getPrincipal());
        }
        catch (Exception e) {
            log.error("No user found, favorites will be disabled");
            return null;
        }
    }

    public MetricsFavoriteController(MetricsFavoriteService metricsFavoriteService) {
        this.metricsFavoriteService = metricsFavoriteService;
    }
}

