/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.component.validator.impl;

import org.apache.hertzbeat.common.entity.manager.Param;
import org.apache.hertzbeat.common.entity.manager.ParamDefine;
import org.apache.hertzbeat.manager.component.validator.ParamValidator;
import org.springframework.stereotype.Component;

@Component
public class ArrayParamValidator
implements ParamValidator {
    @Override
    public boolean support(String type) {
        return "array".equals(type);
    }

    @Override
    public void validate(ParamDefine paramDefine, Param param) {
        String[] arrays = param.getParamValue().split(",");
        if (arrays.length == 0) {
            throw new IllegalArgumentException("Param field " + paramDefine.getField() + " value " + param.getParamValue() + " is invalid arrays value");
        }
        if (param.getParamValue().startsWith("[") && param.getParamValue().endsWith("]")) {
            param.setParamValue(param.getParamValue().substring(1, param.getParamValue().length() - 1));
        }
    }
}

