/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.DnsDomainName;
import org.pcap4j.packet.DnsResourceRecord;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public final class DnsRDataMInfo
implements DnsResourceRecord.DnsRData {
    private static final long serialVersionUID = 3803968528398017544L;
    private final DnsDomainName rMailBx;
    private final DnsDomainName eMailBx;

    public static DnsRDataMInfo newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new DnsRDataMInfo(rawData, offset, length);
    }

    private DnsRDataMInfo(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.rMailBx = DnsDomainName.newInstance(rawData, offset, length);
        int rMailBxLen = this.rMailBx.length();
        if (rMailBxLen == length) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build eMailBx in DnsRDataMInfo. data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.eMailBx = DnsDomainName.newInstance(rawData, offset + rMailBxLen, length - rMailBxLen);
    }

    private DnsRDataMInfo(Builder builder) {
        if (builder == null || builder.rMailBx == null || builder.eMailBx == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.rMailBx: ").append(builder.rMailBx).append(" builder.eMailBx: ").append(builder.eMailBx);
            throw new NullPointerException(sb.toString());
        }
        this.rMailBx = builder.rMailBx;
        this.eMailBx = builder.eMailBx;
    }

    public DnsDomainName getRMailBx() {
        return this.rMailBx;
    }

    public DnsDomainName getEMailBx() {
        return this.eMailBx;
    }

    @Override
    public int length() {
        return this.rMailBx.length() + this.eMailBx.length();
    }

    @Override
    public byte[] getRawData() {
        byte[] data = new byte[this.length()];
        int cursor = 0;
        byte[] rawRMailBx = this.rMailBx.getRawData();
        System.arraycopy(rawRMailBx, 0, data, cursor, rawRMailBx.length);
        byte[] rawEMailBx = this.eMailBx.getRawData();
        System.arraycopy(rawEMailBx, 0, data, cursor += rawRMailBx.length, rawEMailBx.length);
        return data;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.convertToString("", null);
    }

    @Override
    public String toString(String indent) {
        return this.convertToString(indent, null);
    }

    @Override
    public String toString(String indent, byte[] headerRawData) {
        if (headerRawData == null) {
            throw new NullPointerException("headerRawData is null.");
        }
        return this.convertToString(indent, headerRawData);
    }

    private String convertToString(String indent, byte[] headerRawData) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("MINFO RDATA:").append(ls).append(indent).append("  RMAILBX: ").append(headerRawData != null ? this.rMailBx.toString(headerRawData) : this.rMailBx.toString()).append(ls).append(indent).append("  EMAILBX: ").append(headerRawData != null ? this.eMailBx.toString(headerRawData) : this.eMailBx.toString()).append(ls);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.rMailBx.hashCode();
        result = 31 * result + this.eMailBx.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DnsRDataMInfo other = (DnsRDataMInfo)obj;
        if (!this.rMailBx.equals(other.rMailBx)) {
            return false;
        }
        return this.eMailBx.equals(other.eMailBx);
    }

    public static final class Builder {
        private DnsDomainName rMailBx;
        private DnsDomainName eMailBx;

        public Builder() {
        }

        private Builder(DnsRDataMInfo obj) {
            this.rMailBx = obj.rMailBx;
            this.eMailBx = obj.eMailBx;
        }

        public Builder rMailBx(DnsDomainName rMailBx) {
            this.rMailBx = rMailBx;
            return this;
        }

        public Builder eMailBx(DnsDomainName eMailBx) {
            this.eMailBx = eMailBx;
            return this;
        }

        public DnsRDataMInfo build() {
            return new DnsRDataMInfo(this);
        }
    }
}

