/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.ai.tools.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.usthe.sureness.subject.SubjectSum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hertzbeat.ai.config.McpContextHolder;
import org.apache.hertzbeat.ai.tools.AlertDefineTools;
import org.apache.hertzbeat.ai.utils.UtilityClass;
import org.apache.hertzbeat.alert.service.AlertDefineService;
import org.apache.hertzbeat.common.entity.alerter.AlertDefine;
import org.apache.hertzbeat.manager.pojo.dto.Hierarchy;
import org.apache.hertzbeat.manager.service.AppService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.ai.tool.annotation.ToolParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class AlertDefineToolsImpl
implements AlertDefineTools {
    private static final Logger log = LoggerFactory.getLogger(AlertDefineToolsImpl.class);
    @Autowired
    private AlertDefineService alertDefineService;
    @Autowired
    private AppService appService;

    @Override
    @Tool(name="create_alert_rule", description="HertzBeat: ALERT RULE means when to alert a user\nTHESE ARE ALERT RULES WITH THRESHOLD VALUES. USERS CAN SPECIFY THE THRESHOLD VALUES FOR EXAMPLE,\nIF THE USER SAYS \"ALERT ME WHEN MY COST EXCEEDS 700, THE EXPRESSION SHOULD BE 'cost > 700' NOT 'cost < 700'.\nAPPLY THE SAME LOGIC FOR LESS THAN OPERATOR.\nCreate a HertzBeat alert rule based on app hierarchy structure and user requirements.\nIt is important to first understand the hierarchy of apps, metrics, and field conditions\nEach app has its own metrics and each metric has its own field conditions.\nThe operators will be applied to the field conditions, and the final expression will be constructed\nbased on the user's input of app name and the metric they choose.\nCRITICAL WORKFLOW Do all of this iteratively with user interaction at each step\n    1. ALWAYS use list_monitor_types tool FIRST to get exact app name according to what user specifies\n    2. use get_apps_metrics_hierarchy by passing that name, to get the hierarchy of corresponding metrics and field conditions\n    3. Do not spit out the entire hierarchy, instead: first spit out the metrics available for the app\n    4. Ask the user to choose a metric from the available metrics\n    5. Based on the metric chosen, present the available field conditions/params\n    6. You will construct the proper expression with field conditions\n    7. once this tool successfully executes, ask the user if they want to bind any existing monitors to this alert rule,\n    get the monitors list for a particular app using the query_monitors tool.\n    8. based on the user's output, conditionally call the bind_monitors_to_alert_rule tool to bind monitors to the alert rule\n VERY VERY IMPORTANT:\n     - ALWAYS USE the value field from the get_apps_metrics_hierarchy's json response when creating alert expressions on the field parameters\n\nEXAMPLES FOR FIELD CONDITION EXPRESSION( Do not copy these examples, they are just for reference ):\nThese are all just examples, you can take inspiration from them and create a rule based on hierarchy, always ask the user for all params, do not assume them, even for these examples:\n\n1. Kafka JVM Alert:\n   - App: \"kafka\", Metric: \"jvm_basic\"\n   - Field condition: equals(VmName, \"myVM\")\n   - Field condition expression: equals(VmName, \"myVM\")\n\n2. LLM Credits Alert:\n   - App: \"openai\", Metric: \"credit_grants\"\n   - Field condition: total_granted > some_value\n   - Field condition  expression: total_granted > 1000\n\n3. HBase Master Alert:\n   - App: \"hbase_master\", Metric: \"server\"\n   - Field condition: heap_memory_used > 80 or some_factor<100\n   - Field condition  expression: heap_memory_used > 80 or some_factor<100\n\n4. Complex OpenAI Credits Alert:\n   - App: \"openai\", Metric: \"credit_grants\"\n   - Field condition: total_used > 123 and total_granted > 333 and (total_granted > 3444 and total_paid_available < 5556)\n   - Field condition expression: total_used > 123 and total_granted > 333 and (total_granted > 3444 and total_paid_available < 5556)\n\nFIELD CONDITIONS GUIDANCE:\n- Field names come from metric's children in hierarchy (leaf nodes)\n- Use the \"value\" field from the metric's children, not the label when creating conditions\n- Supported operators: >, <, >=, <=, ==, !=, exists(), !exists() for numeric fields\n- equals(), contains(), matches(),exists(), !equals(), !contains(), !matches(), !exists() for string fields\n- Supported logical operators: and, or to connect different field parameter rules or rulesets\n- ONLY USE THESE OPERATORS, when creating conditions, do not use any other operators\n- Support grouping with parentheses: (condition1 and condition2) or condition3\n- String values should be quoted: equals(VmName, \"my-vm\")\n- Simple conditions: heap_memory_used > 80, total_granted <= 1000\n- Complex conditions: total_used > 123 and total_granted > 333 and (total_granted > 3444 and total_paid_available < 5556)\n\nPRIORITY LEVELS:\n- 0: Critical (immediate action required)\n- 1: Warning (attention needed, default)\n- 2: Info (informational only)\n")
    public String createAlertRule(@ToolParam(description="Alert rule name (required, must be unique)", required=true) String name, @ToolParam(description="App name from hierarchy (must match exact hierarchy app value)", required=true) String app, @ToolParam(description="Metrics name from hierarchy (must match exact hierarchy metrics value)", required=true) String metrics, @ToolParam(description="Field conditions expression)", required=true) String fieldConditions, @ToolParam(description="Alert rule type: 'realtime' (default) or 'periodic'", required=false) String type, @ToolParam(description="Execution period in seconds (only for periodic rules, default: 300)", required=false) Integer period, @ToolParam(description="Number of consecutive violations before triggering (default: 3)", required=false) Integer times, @ToolParam(description="Alert priority as integer: 0=critical, 1=warning, 2=info (default: 1)", required=false) Integer priority, @ToolParam(description="Alert rule description (optional)", required=false) String description, @ToolParam(description="Alert message template with variables (optional)", required=false) String template, @ToolParam(description="Data source type: 'promql' (default)", required=false) String datasource, @ToolParam(description="Labels as key:value pairs separated by commas (e.g., 'env:prod,severity:critical')", required=false) String labels, @ToolParam(description="Annotations as key:value pairs separated by commas (e.g., 'summary:High CPU')", required=false) String annotations, @ToolParam(description="Whether to enable the rule immediately (default: true)", required=false) Boolean enable) {
        try {
            String validationResult;
            log.info("Creating HertzBeat alert rule: name={}, app={}, metrics={}, fieldConditions={}", new Object[]{name, app, metrics, fieldConditions});
            SubjectSum subjectSum = McpContextHolder.getSubject();
            log.debug("Current subject in create_alert_rule tool: {}", (Object)subjectSum);
            if (name == null || name.trim().isEmpty()) {
                return "Error: Alert rule name is required";
            }
            if (app == null || app.trim().isEmpty()) {
                return "Error: App name is required (use get_apps_metrics_hierarchy to find exact names)";
            }
            if (metrics == null || metrics.trim().isEmpty()) {
                return "Error: Metrics name is required (use get_apps_metrics_hierarchy to find exact names)";
            }
            if (fieldConditions == null || fieldConditions.trim().isEmpty()) {
                return "Error: Field conditions are required (e.g., 'equals(VmName, \"arora\")', 'total_granted > 1000')";
            }
            if (type == null || type.trim().isEmpty()) {
                type = "realtime";
            }
            if (times == null || times <= 0) {
                times = 3;
            }
            if (priority == null) {
                priority = 1;
            }
            if (enable == null) {
                enable = true;
            }
            if (datasource == null || datasource.trim().isEmpty()) {
                datasource = "promql";
            }
            if (!type.equals("realtime") && !type.equals("periodic")) {
                return "Error: Alert type must be 'realtime' or 'periodic'";
            }
            if (priority < 0 || priority > 2) {
                return "Error: Priority must be 0 (critical), 1 (warning), or 2 (info)";
            }
            if (type.equals("periodic") && (period == null || period <= 0)) {
                period = 300;
            }
            if (!(validationResult = this.validateHierarchyRelationships(app.trim(), metrics.trim(), fieldConditions.trim())).equals("VALID")) {
                return validationResult;
            }
            String expressionValidation = UtilityClass.validateExpressionSyntax(fieldConditions.trim());
            if (!expressionValidation.equals("VALID")) {
                return expressionValidation;
            }
            String expr = String.format("equals(__app__,\"%s\") && equals(__metrics__,\"%s\") && %s", app.trim(), metrics.trim(), fieldConditions.trim());
            HashMap<String, String> labelsMap = new HashMap<String, String>();
            if (labels != null && !labels.trim().isEmpty()) {
                labelsMap.putAll(UtilityClass.parseKeyValuePairs(labels));
            }
            String severityLabel = priority == 0 ? "critical" : (priority == 1 ? "warning" : "info");
            labelsMap.put("severity", severityLabel);
            HashMap<String, String> annotationsMap = new HashMap<String, String>();
            if (annotations != null && !annotations.trim().isEmpty()) {
                annotationsMap.putAll(UtilityClass.parseKeyValuePairs(annotations));
            }
            if (!annotationsMap.containsKey("summary")) {
                annotationsMap.put("summary", description != null ? description : String.format("Alert for %s %s when %s", app, metrics, fieldConditions));
            }
            if (!annotationsMap.containsKey("description")) {
                annotationsMap.put("description", String.format("Monitor %s metrics %s with conditions: %s", app, metrics, fieldConditions));
            }
            if (template == null || template.trim().isEmpty()) {
                template = String.format("Alert: %s %s - %s", app, metrics, fieldConditions);
            }
            AlertDefine alertDefine = AlertDefine.builder().name(name.trim()).type(type).expr(expr).period(period).times(times).labels(labelsMap).annotations(annotationsMap).template(template).datasource(datasource).enable(enable.booleanValue()).build();
            log.debug("Current security subject for addAlertDefine: {}", (Object)subjectSum);
            this.alertDefineService.addAlertDefine(alertDefine);
            String bindingNote = String.format(" (Use bind_monitors_to_alert_rule tool to associate specific monitors)", new Object[0]);
            log.info("Successfully created alert rule '{}' with ID: {}", (Object)name, (Object)alertDefine.getId());
            StringBuilder response = new StringBuilder();
            response.append(String.format("Successfully created %s alert rule '%s' with ID: %d\n", type, name, alertDefine.getId()));
            response.append(String.format("Expression: %s\n", expr));
            response.append(String.format("Priority: %d (%s)\n", priority, severityLabel));
            response.append(String.format("Trigger after: %d consecutive violations\n", times));
            if (type.equals("periodic")) {
                response.append(String.format("Execution period: %d seconds\n", period));
            }
            response.append(String.format("Data source: %s\n", datasource));
            response.append(String.format("Enabled: %s\n", enable));
            if (!labelsMap.isEmpty()) {
                response.append(String.format("Labels: %s\n", labelsMap));
            }
            response.append(bindingNote);
            return response.toString();
        }
        catch (Exception e) {
            log.error("Failed to create alert rule '{}': {}", new Object[]{name, e.getMessage(), e});
            return "Error creating alert rule '" + name + "': " + e.getMessage();
        }
    }

    @Override
    @Tool(name="list_alert_rules", description="HertzBeat: List existing alert rules with filtering options.\nShows configured thresholds and alert definitions.\n")
    public String listAlertRules(@ToolParam(description="Search term for rule name or description", required=false) String search, @ToolParam(description="Filter by monitor type", required=false) String monitorType, @ToolParam(description="Filter by enabled status", required=false) Boolean enabled, @ToolParam(description="Page index (default: 0)", required=false) Integer pageIndex, @ToolParam(description="Page size (default: 10)", required=false) Integer pageSize) {
        try {
            log.info("Listing alert rules: search={}, monitorType={}, enabled={}", new Object[]{search, monitorType, enabled});
            if (pageIndex == null || pageIndex < 0) {
                pageIndex = 0;
            }
            if (pageSize == null || pageSize <= 0) {
                pageSize = 10;
            }
            SubjectSum subjectSum = McpContextHolder.getSubject();
            log.debug("Current security subject for getAlertDefines: {}", (Object)subjectSum);
            Page result = this.alertDefineService.getAlertDefines(null, search, "gmtCreate", "desc", pageIndex.intValue(), pageSize.intValue());
            StringBuilder response = new StringBuilder();
            response.append("Found ").append(result.getContent().size()).append(" alert rules (Total: ").append(result.getTotalElements()).append("):\n\n");
            for (AlertDefine alertDefine : result.getContent()) {
                response.append("Rule ID: ").append(alertDefine.getId()).append("\n");
                response.append("Name: ").append(alertDefine.getName()).append("\n");
                response.append("Expression: ").append(alertDefine.getExpr()).append("\n");
                response.append("Type: ").append(alertDefine.getType()).append("\n");
                response.append("Trigger Times: ").append(alertDefine.getTimes()).append("\n");
                response.append("Enabled: ").append(alertDefine.isEnable()).append("\n");
                if (alertDefine.getLabels() != null && !alertDefine.getLabels().isEmpty()) {
                    response.append("Labels: ").append(alertDefine.getLabels()).append("\n");
                }
                if (alertDefine.getAnnotations() != null && !alertDefine.getAnnotations().isEmpty()) {
                    response.append("Summary: ").append((String)alertDefine.getAnnotations().get("summary")).append("\n");
                }
                response.append("Created: ").append(alertDefine.getGmtCreate()).append("\n");
                response.append("\n");
            }
            if (result.getContent().isEmpty()) {
                response.append("No alert rules found matching the specified criteria.");
            }
            return response.toString();
        }
        catch (Exception e) {
            log.error("Failed to list alert rules: {}", (Object)e.getMessage(), (Object)e);
            return "Error retrieving alert rules: " + e.getMessage();
        }
    }

    @Override
    @Tool(name="toggle_alert_rule", description="HertzBeat: Enable or disable an alert rule.\nAllows activating or deactivating threshold monitoring.\n")
    public String toggleAlertRule(@ToolParam(description="Alert rule ID", required=true) Long ruleId, @ToolParam(description="Whether to enable the rule", required=true) Boolean enabled) {
        try {
            log.info("Toggling alert rule ID: {} to enabled: {}", (Object)ruleId, (Object)enabled);
            SubjectSum subjectSum = McpContextHolder.getSubject();
            log.debug("Current security subject for toggleAlertDefineStatus: {}", (Object)subjectSum);
            AlertDefine alertDefine = this.alertDefineService.getAlertDefine(ruleId.longValue());
            if (alertDefine == null) {
                throw new RuntimeException("AlertDefine with ID " + ruleId + " not found");
            }
            alertDefine.setEnable(enabled.booleanValue());
            this.alertDefineService.modifyAlertDefine(alertDefine);
            log.info("Successfully toggled alert rule ID: {} to enabled: {}", (Object)ruleId, (Object)enabled);
            return String.format("Successfully %s alert rule ID: %d", enabled != false ? "enabled" : "disabled", ruleId);
        }
        catch (Exception e) {
            log.error("Failed to toggle alert rule ID {}: {}", new Object[]{ruleId, e.getMessage(), e});
            return "Error toggling alert rule: " + e.getMessage();
        }
    }

    @Override
    @Tool(name="get_alert_rule_details", description="HertzBeat: Get detailed information about a specific alert rule.\nShows complete threshold configuration and rule settings.\n")
    public String getAlertRuleDetails(@ToolParam(description="Alert rule ID", required=true) Long ruleId) {
        try {
            log.info("Getting alert rule details for ID: {}", (Object)ruleId);
            SubjectSum subjectSum = McpContextHolder.getSubject();
            log.debug("Current security subject for getAlertDefine: {}", (Object)subjectSum);
            AlertDefine alertDefine = this.alertDefineService.getAlertDefine(ruleId.longValue());
            if (alertDefine == null) {
                return "Alert rule with ID " + ruleId + " not found";
            }
            StringBuilder response = new StringBuilder();
            response.append("ALERT RULE DETAILS\n");
            response.append("==================\n\n");
            response.append("Rule ID: ").append(alertDefine.getId()).append("\n");
            response.append("Name: ").append(alertDefine.getName()).append("\n");
            response.append("Type: ").append(alertDefine.getType()).append("\n");
            response.append("Expression: ").append(alertDefine.getExpr()).append("\n");
            response.append("Trigger Times: ").append(alertDefine.getTimes()).append("\n");
            response.append("Enabled: ").append(alertDefine.isEnable()).append("\n");
            if (alertDefine.getPeriod() != null) {
                response.append("Period: ").append(alertDefine.getPeriod()).append(" seconds\n");
            }
            if (alertDefine.getLabels() != null && !alertDefine.getLabels().isEmpty()) {
                response.append("Labels: ").append(alertDefine.getLabels()).append("\n");
            }
            if (alertDefine.getAnnotations() != null && !alertDefine.getAnnotations().isEmpty()) {
                response.append("Annotations: ").append(alertDefine.getAnnotations()).append("\n");
            }
            if (alertDefine.getTemplate() != null) {
                response.append("Template: ").append(alertDefine.getTemplate()).append("\n");
            }
            response.append("Created: ").append(alertDefine.getGmtCreate()).append("\n");
            response.append("Modified: ").append(alertDefine.getGmtUpdate()).append("\n");
            response.append("Creator: ").append(alertDefine.getCreator()).append("\n");
            response.append("Modifier: ").append(alertDefine.getModifier()).append("\n");
            return response.toString();
        }
        catch (Exception e) {
            log.error("Failed to get alert rule details for ID {}: {}", new Object[]{ruleId, e.getMessage(), e});
            return "Error retrieving alert rule details: " + e.getMessage();
        }
    }

    @Override
    @Tool(name="get_apps_metrics_hierarchy", description="HertzBeat: Get the hierarchical structure of all available apps and their metrics for alert rule creation.\nThis tool provides the exact app name, metric name and corresponding param names according to each metric.\nReturns structured JSON data showing the complete hierarchy with field parameters for alert expressions.\n\nJSON Structure:\n- app: The application name\n- description: Tool description\n- hierarchy: Array of hierarchical data\n  - Each node has: value, label, type, description\n  - Leaf nodes have: dataType (numeric/string), unit (if applicable)\n  - Non-leaf nodes have: children array\n VERY IMPORTANT:\n  - ALWAYS USE the value field from the field parameters when creating alert expressions.\n\nThis structured data is needed to create proper alert expressions.\n")
    public String getAppsMetricsHierarchy(@ToolParam(description="App/Monitor type to get hierarchy for (e.g., 'linux', 'mysql', 'website')", required=true) String app) {
        try {
            log.info("Getting apps metrics hierarchy for app: {}", (Object)app);
            SubjectSum subjectSum = McpContextHolder.getSubject();
            log.debug("Current subject in get_apps_metrics_hierarchy tool: {}", (Object)subjectSum);
            List hierarchies = this.appService.getAppHierarchy(app.trim().toLowerCase(), "en-US");
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode result = mapper.createObjectNode();
            result.put("app", app.toUpperCase());
            if (hierarchies != null && !hierarchies.isEmpty()) {
                ArrayNode hierarchyArray = mapper.createArrayNode();
                for (Hierarchy hierarchy : hierarchies) {
                    hierarchyArray.add((JsonNode)UtilityClass.formatHierarchyAsJson(mapper, hierarchy));
                }
                result.set("hierarchy", (JsonNode)hierarchyArray);
            } else {
                result.put("message", "No hierarchy data available");
            }
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)result);
        }
        catch (Exception e) {
            log.error("Failed to get apps metrics hierarchy: {}", (Object)e.getMessage(), (Object)e);
            return "Error retrieving apps metrics hierarchy: " + e.getMessage();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Tool(name="bind_monitors_to_alert_rule", description="HertzBeat: Bind monitors to an alert rule.\nCall this tool if users want to bind specific monitors to their alert rule.\nGet the right monitor ids for a particular app using the query_monitors tool.\nGet the alert rule ID from the create_alert_rule tool output OR use the list_alert_rules tool with app_name search filter, if the output of create_alert_rule is not applicable.\nIf monitors are already bound, this will add the new ones to the existing bindings.\n")
    public String bindMonitorsToAlertRule(@ToolParam(description="Alert rule ID to bind monitors to", required=true) Long ruleId, @ToolParam(description="Comma-separated list of monitor IDs to bind", required=true) String monitorIds) {
        try {
            String monitorCondition;
            log.info("Binding monitors to alert rule ID: {}, monitors: {}", (Object)ruleId, (Object)monitorIds);
            SubjectSum subjectSum = McpContextHolder.getSubject();
            log.debug("Current subject in bind_monitors_to_alert_rule tool: {}", (Object)subjectSum);
            if (ruleId == null || ruleId <= 0L) {
                return "Error: Valid alert rule ID is required";
            }
            if (monitorIds == null) {
                return "Error: Monitor IDs are required";
            }
            log.debug("Current security subject for getAlertDefine: {}", (Object)subjectSum);
            AlertDefine existingRule = this.alertDefineService.getAlertDefine(ruleId.longValue());
            if (existingRule == null) {
                return String.format("Error: Alert rule with ID %d not found", ruleId);
            }
            String[] monitorIdArray = monitorIds.split(",");
            ArrayList<String> validMonitorIds = new ArrayList<String>();
            for (String monitorId : monitorIdArray) {
                String trimmedId = monitorId.trim();
                if (trimmedId.isEmpty()) continue;
                try {
                    Long.parseLong(trimmedId);
                    validMonitorIds.add(trimmedId);
                }
                catch (NumberFormatException e) {
                    return String.format("Error: Invalid monitor ID '%s'. Monitor IDs must be numeric.", trimmedId);
                }
            }
            if (validMonitorIds.isEmpty()) {
                return "Error: No valid monitor IDs provided";
            }
            if (validMonitorIds.size() == 1) {
                monitorCondition = String.format("equals(__instance__, \"%s\")", validMonitorIds.get(0));
            } else {
                StringBuilder conditionBuilder = new StringBuilder("(");
                for (int i = 0; i < validMonitorIds.size(); ++i) {
                    if (i > 0) {
                        conditionBuilder.append(" or ");
                    }
                    conditionBuilder.append(String.format("equals(__instance__, \"%s\")", validMonitorIds.get(i)));
                }
                conditionBuilder.append(")");
                monitorCondition = conditionBuilder.toString();
            }
            String currentExpr = existingRule.getExpr();
            if (currentExpr.contains("__instance__")) {
                String updatedMonitorCondition;
                List<String> existingMonitorIds = UtilityClass.extractExistingMonitorIds(currentExpr);
                for (String newId : validMonitorIds) {
                    if (existingMonitorIds.contains(newId)) continue;
                    existingMonitorIds.add(newId);
                }
                if (existingMonitorIds.size() == 1) {
                    updatedMonitorCondition = String.format("equals(__instance__, \"%s\")", existingMonitorIds.get(0));
                } else {
                    StringBuilder conditionBuilder = new StringBuilder("(");
                    for (int i = 0; i < existingMonitorIds.size(); ++i) {
                        if (i > 0) {
                            conditionBuilder.append(" or ");
                        }
                        conditionBuilder.append(String.format("equals(__instance__, \"%s\")", existingMonitorIds.get(i)));
                    }
                    conditionBuilder.append(")");
                    updatedMonitorCondition = conditionBuilder.toString();
                }
                String newExpr = UtilityClass.replaceInstanceConditions(currentExpr, updatedMonitorCondition);
                existingRule.setExpr(newExpr);
                log.debug("Current security subject for modifyAlertDefine: {}", (Object)subjectSum);
                this.alertDefineService.modifyAlertDefine(existingRule);
                log.info("Successfully added monitors {} to existing bindings for alert rule ID: {}", validMonitorIds, (Object)ruleId);
                return String.format("Successfully added %d new monitor(s) to alert rule ID %d.\nTotal bound monitors: %s\nUpdated expression: %s", validMonitorIds.size(), ruleId, String.join((CharSequence)", ", existingMonitorIds), newExpr);
            }
            if (!currentExpr.matches(".*equals\\(__app__,\"[^\"]+\"\\)\\s*&&\\s*equals\\(__metrics__,\"[^\"]+\"\\)\\s*&&\\s*.*")) return String.format("Error: Expression format not supported for monitor binding: %s", currentExpr);
            String metricsPattern = "equals\\(__metrics__,\"[^\"]+\"\\)";
            Pattern regex = Pattern.compile(metricsPattern);
            Matcher matcher = regex.matcher(currentExpr);
            if (!matcher.find()) return String.format("Error: Unable to parse metrics condition in expression: %s", currentExpr);
            int metricsEnd = matcher.end();
            int andPosition = currentExpr.indexOf(" && ", metricsEnd);
            if (andPosition == -1) {
                return String.format("Error: Unable to find field conditions after metrics in expression: %s", currentExpr);
            }
            String beforeAndPosition = currentExpr.substring(0, andPosition + 4);
            String afterAndPosition = currentExpr.substring(andPosition + 4);
            String newExpr = beforeAndPosition + monitorCondition + " && " + afterAndPosition;
            existingRule.setExpr(newExpr);
            this.alertDefineService.modifyAlertDefine(existingRule);
            log.info("Successfully bound monitors {} to alert rule ID: {}", validMonitorIds, (Object)ruleId);
            return String.format("Successfully bound %d monitor(s) to alert rule ID %d.\nMonitor IDs: %s\nUpdated expression: %s", validMonitorIds.size(), ruleId, String.join((CharSequence)", ", validMonitorIds), newExpr);
        }
        catch (Exception e) {
            log.error("Failed to bind monitors to alert rule ID {}: {}", new Object[]{ruleId, e.getMessage(), e});
            return String.format("Error binding monitors to alert rule: %s", e.getMessage());
        }
    }

    private String validateHierarchyRelationships(String app, String metrics, String fieldConditions) {
        try {
            log.debug("Validating hierarchy relationships: app={}, metrics={}, fieldConditions={}", new Object[]{app, metrics, fieldConditions});
            SubjectSum subjectSum = McpContextHolder.getSubject();
            log.debug("Current security subject for getAppHierarchy: {}", (Object)subjectSum);
            List hierarchies = this.appService.getAppHierarchy(app.toLowerCase(), "en-US");
            if (hierarchies == null || hierarchies.isEmpty()) {
                return String.format("Error: App '%s' not found in hierarchy. Please use list_monitor_types to get valid app names.", app);
            }
            Hierarchy metricHierarchy = UtilityClass.findMetricInHierarchy(hierarchies, metrics);
            if (metricHierarchy == null) {
                return String.format("Error: Metric '%s' not found for app '%s'. Please use get_apps_metrics_hierarchy to get valid metrics for this app.", metrics, app);
            }
            List<String> fieldNames = UtilityClass.extractFieldNamesFromConditions(fieldConditions);
            for (String fieldName : fieldNames) {
                if (UtilityClass.isFieldValidForMetric(metricHierarchy, fieldName)) continue;
                return String.format("Error: Field '%s' not found for metric '%s' in app '%s'. Please use get_apps_metrics_hierarchy to get valid field parameters.", fieldName, metrics, app);
            }
            log.debug("Hierarchy validation passed for app={}, metrics={}", (Object)app, (Object)metrics);
            return "VALID";
        }
        catch (Exception e) {
            log.error("Error during hierarchy validation: {}", (Object)e.getMessage(), (Object)e);
            return String.format("Error: Unable to validate hierarchy relationships: %s", e.getMessage());
        }
    }
}

