/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.net.URI;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.codec.LoggingCodecSupport;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.DefaultClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClientRequestException;
import org.springframework.web.reactive.function.client.WebClientUtils;
import reactor.core.publisher.Mono;

public abstract class ExchangeFunctions {
    private static final Log logger = LogFactory.getLog(ExchangeFunctions.class);

    public static ExchangeFunction create(ClientHttpConnector connector) {
        return ExchangeFunctions.create(connector, ExchangeStrategies.withDefaults());
    }

    public static ExchangeFunction create(ClientHttpConnector connector, ExchangeStrategies strategies) {
        return new DefaultExchangeFunction(connector, strategies);
    }

    private static class DefaultExchangeFunction
    implements ExchangeFunction {
        private final ClientHttpConnector connector;
        private final ExchangeStrategies strategies;
        private boolean enableLoggingRequestDetails;

        public DefaultExchangeFunction(ClientHttpConnector connector, ExchangeStrategies strategies) {
            Assert.notNull((Object)connector, (String)"ClientHttpConnector must not be null");
            Assert.notNull((Object)strategies, (String)"ExchangeStrategies must not be null");
            this.connector = connector;
            this.strategies = strategies;
            strategies.messageWriters().stream().filter(LoggingCodecSupport.class::isInstance).forEach(reader -> {
                if (((LoggingCodecSupport)reader).isEnableLoggingRequestDetails()) {
                    this.enableLoggingRequestDetails = true;
                }
            });
        }

        @Override
        public Mono<ClientResponse> exchange(ClientRequest clientRequest) {
            Assert.notNull((Object)clientRequest, (String)"ClientRequest must not be null");
            HttpMethod httpMethod = clientRequest.method();
            URI url = clientRequest.url();
            return this.connector.connect(httpMethod, url, httpRequest -> clientRequest.writeTo((ClientHttpRequest)httpRequest, this.strategies)).doOnRequest(n -> this.logRequest(clientRequest)).doOnCancel(() -> logger.debug((Object)(clientRequest.logPrefix() + "Cancel signal (to close connection)"))).onErrorResume(WebClientUtils.WRAP_EXCEPTION_PREDICATE, t -> this.wrapException((Throwable)t, clientRequest)).map(httpResponse -> {
                String logPrefix = this.getLogPrefix(clientRequest, (ClientHttpResponse)httpResponse);
                this.logResponse((ClientHttpResponse)httpResponse, logPrefix);
                return new DefaultClientResponse((ClientHttpResponse)httpResponse, this.strategies, logPrefix, httpMethod.name() + " " + url, () -> this.createRequest(clientRequest));
            });
        }

        private void logRequest(ClientRequest request) {
            LogFormatUtils.traceDebug((Log)logger, traceOn -> request.logPrefix() + "HTTP " + request.method() + " " + request.url() + (String)(traceOn != false ? ", headers=" + this.formatHeaders(request.headers()) : ""));
        }

        private String getLogPrefix(ClientRequest request, ClientHttpResponse response) {
            return request.logPrefix() + "[" + response.getId() + "] ";
        }

        private void logResponse(ClientHttpResponse response, String logPrefix) {
            LogFormatUtils.traceDebug((Log)logger, traceOn -> logPrefix + "Response " + response.getStatusCode() + (String)(traceOn != false ? ", headers=" + this.formatHeaders(response.getHeaders()) : ""));
        }

        private String formatHeaders(HttpHeaders headers) {
            return this.enableLoggingRequestDetails ? headers.toString() : (headers.isEmpty() ? "{}" : "{masked}");
        }

        private <T> Mono<T> wrapException(Throwable t, ClientRequest r) {
            return Mono.error(() -> new WebClientRequestException(t, r.method(), r.url(), r.headers()));
        }

        private HttpRequest createRequest(final ClientRequest request) {
            return new HttpRequest(){

                public HttpMethod getMethod() {
                    return request.method();
                }

                public URI getURI() {
                    return request.url();
                }

                public Map<String, Object> getAttributes() {
                    return request.attributes();
                }

                public HttpHeaders getHeaders() {
                    return request.headers();
                }
            };
        }
    }
}

