/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.queue.impl;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hertzbeat.common.config.CommonProperties;
import org.apache.hertzbeat.common.entity.log.LogEntry;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.queue.CommonDataQueue;
import org.apache.hertzbeat.common.serialize.KafkaLogEntryDeserializer;
import org.apache.hertzbeat.common.serialize.KafkaLogEntrySerializer;
import org.apache.hertzbeat.common.serialize.KafkaMetricsDataDeserializer;
import org.apache.hertzbeat.common.serialize.KafkaMetricsDataSerializer;
import org.apache.hertzbeat.common.support.exception.CommonDataQueueUnknownException;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="common.queue", name={"type"}, havingValue="kafka")
public class KafkaCommonDataQueue
implements CommonDataQueue,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(KafkaCommonDataQueue.class);
    private final ReentrantLock metricDataToAlertLock = new ReentrantLock();
    private final ReentrantLock metricDataToStorageLock = new ReentrantLock();
    private final ReentrantLock serviceDiscoveryDataLock = new ReentrantLock();
    private final ReentrantLock logEntryLock = new ReentrantLock();
    private final ReentrantLock logEntryToStorageLock = new ReentrantLock();
    private final LinkedBlockingQueue<CollectRep.MetricsData> metricsDataToAlertQueue;
    private final LinkedBlockingQueue<CollectRep.MetricsData> metricsDataToStorageQueue;
    private final LinkedBlockingQueue<CollectRep.MetricsData> serviceDiscoveryDataQueue;
    private final LinkedBlockingQueue<LogEntry> logEntryQueue;
    private final LinkedBlockingQueue<LogEntry> logEntryToStorageQueue;
    private final CommonProperties.KafkaProperties kafka;
    private KafkaProducer<Long, CollectRep.MetricsData> metricsDataProducer;
    private KafkaProducer<Long, LogEntry> logEntryProducer;
    private KafkaConsumer<Long, CollectRep.MetricsData> metricsDataToAlertConsumer;
    private KafkaConsumer<Long, CollectRep.MetricsData> metricsDataToStorageConsumer;
    private KafkaConsumer<Long, CollectRep.MetricsData> serviceDiscoveryDataConsumer;
    private KafkaConsumer<Long, LogEntry> logEntryConsumer;
    private KafkaConsumer<Long, LogEntry> logEntryToStorageConsumer;

    public KafkaCommonDataQueue(CommonProperties properties) {
        if (properties == null || properties.getQueue() == null || properties.getQueue().getKafka() == null) {
            log.error("init error, please config common.queue.kafka props in application.yml");
            throw new IllegalArgumentException("please config common.queue.kafka props");
        }
        this.kafka = properties.getQueue().getKafka();
        this.metricsDataToAlertQueue = new LinkedBlockingQueue();
        this.metricsDataToStorageQueue = new LinkedBlockingQueue();
        this.serviceDiscoveryDataQueue = new LinkedBlockingQueue();
        this.logEntryQueue = new LinkedBlockingQueue();
        this.logEntryToStorageQueue = new LinkedBlockingQueue();
        this.initDataQueue();
    }

    private void initDataQueue() {
        try {
            HashMap<String, Object> producerConfig = new HashMap<String, Object>(3);
            producerConfig.put("bootstrap.servers", this.kafka.getServers());
            producerConfig.put("acks", "all");
            producerConfig.put("retries", 3);
            this.metricsDataProducer = new KafkaProducer(producerConfig, (Serializer)new LongSerializer(), (Serializer)new KafkaMetricsDataSerializer());
            this.logEntryProducer = new KafkaProducer(producerConfig, (Serializer)new LongSerializer(), (Serializer)new KafkaLogEntrySerializer());
            HashMap<String, Object> consumerConfig = new HashMap<String, Object>(4);
            consumerConfig.put("bootstrap.servers", this.kafka.getServers());
            consumerConfig.put("max.poll.records", "50");
            consumerConfig.put("enable.auto.commit", false);
            consumerConfig.put("max.poll.interval.ms", "900000");
            consumerConfig.put("group.id", "default-consumer");
            HashMap<String, String> metricsToAlertConsumerConfig = new HashMap<String, String>(consumerConfig);
            metricsToAlertConsumerConfig.put("group.id", "metrics-alert-consumer");
            this.metricsDataToAlertConsumer = new KafkaConsumer(metricsToAlertConsumerConfig, (Deserializer)new LongDeserializer(), (Deserializer)new KafkaMetricsDataDeserializer());
            this.metricsDataToAlertConsumer.subscribe(Collections.singletonList(this.kafka.getMetricsDataTopic()));
            HashMap<String, String> metricsToStorageConsumerConfig = new HashMap<String, String>(consumerConfig);
            metricsToStorageConsumerConfig.put("group.id", "metrics-persistent-consumer");
            this.metricsDataToStorageConsumer = new KafkaConsumer(metricsToStorageConsumerConfig, (Deserializer)new LongDeserializer(), (Deserializer)new KafkaMetricsDataDeserializer());
            this.metricsDataToStorageConsumer.subscribe(Collections.singletonList(this.kafka.getMetricsDataToStorageTopic()));
            HashMap<String, String> serviceDiscoveryDataConsumerConfig = new HashMap<String, String>(consumerConfig);
            serviceDiscoveryDataConsumerConfig.put("group.id", "service-discovery-data-consumer");
            this.serviceDiscoveryDataConsumer = new KafkaConsumer(serviceDiscoveryDataConsumerConfig, (Deserializer)new LongDeserializer(), (Deserializer)new KafkaMetricsDataDeserializer());
            this.serviceDiscoveryDataConsumer.subscribe(Collections.singletonList(this.kafka.getServiceDiscoveryDataTopic()));
            HashMap<String, String> logEntryConsumerConfig = new HashMap<String, String>(consumerConfig);
            logEntryConsumerConfig.put("group.id", "log-entry-consumer");
            this.logEntryConsumer = new KafkaConsumer(logEntryConsumerConfig, (Deserializer)new LongDeserializer(), (Deserializer)new KafkaLogEntryDeserializer());
            this.logEntryConsumer.subscribe(Collections.singletonList(this.kafka.getLogEntryDataTopic()));
            HashMap<String, String> logEntryToStorageConsumerConfig = new HashMap<String, String>(consumerConfig);
            logEntryToStorageConsumerConfig.put("group.id", "log-entry-storage-consumer");
            this.logEntryToStorageConsumer = new KafkaConsumer(logEntryToStorageConsumerConfig, (Deserializer)new LongDeserializer(), (Deserializer)new KafkaLogEntryDeserializer());
            this.logEntryToStorageConsumer.subscribe(Collections.singletonList(this.kafka.getLogEntryDataToStorageTopic()));
        }
        catch (Exception e) {
            log.error("please config common.queue.kafka props correctly", (Throwable)e);
            throw e;
        }
    }

    @Override
    public CollectRep.MetricsData pollServiceDiscoveryData() throws InterruptedException {
        return this.genericPollDataFunction(this.serviceDiscoveryDataQueue, this.serviceDiscoveryDataConsumer, this.serviceDiscoveryDataLock);
    }

    @Override
    public CollectRep.MetricsData pollMetricsDataToAlerter() throws InterruptedException {
        return this.genericPollDataFunction(this.metricsDataToAlertQueue, this.metricsDataToAlertConsumer, this.metricDataToAlertLock);
    }

    @Override
    public CollectRep.MetricsData pollMetricsDataToStorage() throws InterruptedException {
        return this.genericPollDataFunction(this.metricsDataToStorageQueue, this.metricsDataToStorageConsumer, this.metricDataToStorageLock);
    }

    public <T> T genericPollDataFunction(LinkedBlockingQueue<T> dataQueue, KafkaConsumer<Long, T> dataConsumer, ReentrantLock lock) throws InterruptedException {
        Object pollData = dataQueue.poll();
        if (pollData != null) {
            return pollData;
        }
        lock.lockInterruptibly();
        try {
            ConsumerRecords records = dataConsumer.poll(Duration.ofSeconds(1L));
            int index = 0;
            for (ConsumerRecord record : records) {
                if (index == 0) {
                    pollData = record.value();
                } else {
                    dataQueue.offer(record.value());
                }
                ++index;
            }
            dataConsumer.commitAsync();
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new CommonDataQueueUnknownException(e.getMessage(), e);
        }
        finally {
            lock.unlock();
        }
        return pollData;
    }

    @Override
    public void sendMetricsData(CollectRep.MetricsData metricsData) {
        if (this.metricsDataProducer != null) {
            ProducerRecord record = new ProducerRecord(this.kafka.getMetricsDataTopic(), (Object)metricsData);
            this.metricsDataProducer.send(record);
        } else {
            log.error("metricsDataProducer is not enabled");
        }
    }

    @Override
    public void sendMetricsDataToStorage(CollectRep.MetricsData metricsData) {
        if (this.metricsDataProducer != null) {
            ProducerRecord record = new ProducerRecord(this.kafka.getMetricsDataToStorageTopic(), (Object)metricsData);
            this.metricsDataProducer.send(record);
        } else {
            log.error("metricsDataProducer is not enabled");
        }
    }

    @Override
    public void sendServiceDiscoveryData(CollectRep.MetricsData metricsData) {
        if (this.metricsDataProducer != null) {
            ProducerRecord record = new ProducerRecord(this.kafka.getServiceDiscoveryDataTopic(), (Object)metricsData);
            this.metricsDataProducer.send(record);
        } else {
            log.error("metricsDataProducer is not enabled");
        }
    }

    @Override
    public void sendLogEntry(LogEntry logEntry) {
        if (this.logEntryProducer != null) {
            try {
                ProducerRecord record = new ProducerRecord(this.kafka.getLogEntryDataTopic(), (Object)logEntry);
                this.logEntryProducer.send(record);
            }
            catch (Exception e) {
                log.error("Failed to send LogEntry to Kafka: {}", (Object)e.getMessage());
                this.logEntryQueue.offer(logEntry);
            }
        } else {
            log.warn("logEntryProducer is not enabled, using memory queue");
            this.logEntryQueue.offer(logEntry);
        }
    }

    @Override
    public LogEntry pollLogEntry() throws InterruptedException {
        return this.genericPollDataFunction(this.logEntryQueue, this.logEntryConsumer, this.logEntryLock);
    }

    @Override
    public void sendLogEntryToStorage(LogEntry logEntry) {
        if (this.logEntryProducer != null) {
            try {
                ProducerRecord record = new ProducerRecord(this.kafka.getLogEntryDataToStorageTopic(), (Object)logEntry);
                this.logEntryProducer.send(record);
            }
            catch (Exception e) {
                log.error("Failed to send LogEntry to storage via Kafka: {}", (Object)e.getMessage());
                this.logEntryToStorageQueue.offer(logEntry);
            }
        } else {
            log.warn("logEntryProducer is not enabled, using memory queue for storage");
            this.logEntryToStorageQueue.offer(logEntry);
        }
    }

    @Override
    public LogEntry pollLogEntryToStorage() throws InterruptedException {
        return this.genericPollDataFunction(this.logEntryToStorageQueue, this.logEntryToStorageConsumer, this.logEntryToStorageLock);
    }

    @Override
    public void sendLogEntryToAlertBatch(List<LogEntry> logEntries) {
        if (logEntries == null || logEntries.isEmpty()) {
            return;
        }
        if (this.logEntryProducer != null) {
            try {
                for (LogEntry logEntry : logEntries) {
                    ProducerRecord record = new ProducerRecord(this.kafka.getLogEntryDataTopic(), (Object)logEntry);
                    this.logEntryProducer.send(record);
                }
            }
            catch (Exception e) {
                log.error("Failed to send LogEntry batch to Kafka: {}", (Object)e.getMessage());
                for (LogEntry logEntry : logEntries) {
                    this.logEntryQueue.offer(logEntry);
                }
            }
        } else {
            log.warn("logEntryProducer is not enabled, using memory queue");
            for (LogEntry logEntry : logEntries) {
                this.logEntryQueue.offer(logEntry);
            }
        }
    }

    @Override
    public List<LogEntry> pollLogEntryToAlertBatch(int maxBatchSize) throws InterruptedException {
        return this.genericBatchPollDataFunction(this.logEntryQueue, this.logEntryConsumer, this.logEntryLock, maxBatchSize);
    }

    @Override
    public void sendLogEntryToStorageBatch(List<LogEntry> logEntries) {
        if (logEntries == null || logEntries.isEmpty()) {
            return;
        }
        if (this.logEntryProducer != null) {
            try {
                for (LogEntry logEntry : logEntries) {
                    ProducerRecord record = new ProducerRecord(this.kafka.getLogEntryDataToStorageTopic(), (Object)logEntry);
                    this.logEntryProducer.send(record);
                }
            }
            catch (Exception e) {
                log.error("Failed to send LogEntry batch to storage via Kafka: {}", (Object)e.getMessage());
                for (LogEntry logEntry : logEntries) {
                    this.logEntryToStorageQueue.offer(logEntry);
                }
            }
        } else {
            log.warn("logEntryProducer is not enabled, using memory queue for storage");
            for (LogEntry logEntry : logEntries) {
                this.logEntryToStorageQueue.offer(logEntry);
            }
        }
    }

    @Override
    public List<LogEntry> pollLogEntryToStorageBatch(int maxBatchSize) throws InterruptedException {
        return this.genericBatchPollDataFunction(this.logEntryToStorageQueue, this.logEntryToStorageConsumer, this.logEntryToStorageLock, maxBatchSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> genericBatchPollDataFunction(LinkedBlockingQueue<T> dataQueue, KafkaConsumer<Long, T> dataConsumer, ReentrantLock lock, int maxBatchSize) throws InterruptedException {
        ArrayList<Object> batch = new ArrayList<Object>(maxBatchSize);
        lock.lockInterruptibly();
        try {
            dataQueue.drainTo(batch, maxBatchSize);
            if (batch.size() >= maxBatchSize) {
                ArrayList<Object> arrayList = batch;
                return arrayList;
            }
            ConsumerRecords records = dataConsumer.poll(Duration.ofSeconds(1L));
            for (ConsumerRecord record : records) {
                if (batch.size() < maxBatchSize) {
                    batch.add(record.value());
                    continue;
                }
                dataQueue.offer(record.value());
            }
            dataConsumer.commitAsync();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        finally {
            lock.unlock();
        }
        return batch;
    }

    public void destroy() throws Exception {
        if (this.metricsDataProducer != null) {
            this.metricsDataProducer.close();
        }
        if (this.metricsDataToAlertConsumer != null) {
            this.metricsDataToAlertConsumer.close();
        }
        if (this.metricsDataToStorageConsumer != null) {
            this.metricsDataToStorageConsumer.close();
        }
        if (this.serviceDiscoveryDataConsumer != null) {
            this.serviceDiscoveryDataConsumer.close();
        }
        if (this.logEntryProducer != null) {
            this.logEntryProducer.close();
        }
        if (this.logEntryConsumer != null) {
            this.logEntryConsumer.close();
        }
        if (this.logEntryToStorageConsumer != null) {
            this.logEntryToStorageConsumer.close();
        }
    }
}

