/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseServerException;
import org.apache.hadoop.hbase.util.DynamicClassLoader;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class RemoteWithExtrasException
extends RemoteException {
    private final String hostname;
    private final int port;
    private final boolean doNotRetry;
    private final boolean serverOverloaded;

    public RemoteWithExtrasException(String className, String msg, boolean doNotRetry) {
        this(className, msg, doNotRetry, false);
    }

    public RemoteWithExtrasException(String className, String msg, boolean doNotRetry, boolean serverOverloaded) {
        this(className, msg, null, -1, doNotRetry, serverOverloaded);
    }

    public RemoteWithExtrasException(String className, String msg, String hostname, int port, boolean doNotRetry) {
        this(className, msg, hostname, port, doNotRetry, false);
    }

    public RemoteWithExtrasException(String className, String msg, String hostname, int port, boolean doNotRetry, boolean serverOverloaded) {
        super(className, msg);
        this.hostname = hostname;
        this.port = port;
        this.doNotRetry = doNotRetry;
        this.serverOverloaded = serverOverloaded;
    }

    public IOException unwrapRemoteException() {
        Class<?> realClass;
        try {
            realClass = Class.forName(this.getClassName(), false, ClassLoaderHolder.CLASS_LOADER);
        }
        catch (ClassNotFoundException cnfe) {
            try {
                realClass = Class.forName(this.getClassName(), false, super.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                return new DoNotRetryIOException("Unable to load exception received from server:" + e.getMessage(), (Throwable)((Object)this));
            }
        }
        try {
            return this.instantiateException(realClass.asSubclass(IOException.class));
        }
        catch (Exception e) {
            return new DoNotRetryIOException("Unable to instantiate exception received from server:" + e.getMessage(), (Throwable)((Object)this));
        }
    }

    private IOException instantiateException(Class<? extends IOException> cls) throws Exception {
        Constructor<? extends IOException> cn = cls.getConstructor(String.class);
        cn.setAccessible(true);
        IOException ex = cn.newInstance(this.getMessage());
        ex.initCause((Throwable)((Object)this));
        if (ex instanceof HBaseServerException) {
            HBaseServerException serverException = (HBaseServerException)ex;
            if (this.serverOverloaded && !serverException.isServerOverloaded()) {
                serverException.setServerOverloaded(true);
            }
        }
        return ex;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isDoNotRetry() {
        return this.doNotRetry;
    }

    public boolean isServerOverloaded() {
        return this.serverOverloaded;
    }

    private static final class ClassLoaderHolder {
        private static final ClassLoader CLASS_LOADER;

        private ClassLoaderHolder() {
        }

        static {
            ClassLoader parent = RemoteWithExtrasException.class.getClassLoader();
            Configuration conf = HBaseConfiguration.create();
            CLASS_LOADER = AccessController.doPrivileged(() -> new DynamicClassLoader(conf, parent));
        }
    }
}

