/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.List;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlushRandomRegionOfTableAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(FlushRandomRegionOfTableAction.class);
    private final long sleepTime;
    private final TableName tableName;

    public FlushRandomRegionOfTableAction(TableName tableName) {
        this(-1, tableName);
    }

    public FlushRandomRegionOfTableAction(int sleepTime, TableName tableName) {
        this.sleepTime = sleepTime;
        this.tableName = tableName;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws Exception {
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        Admin admin = util.getAdmin();
        this.getLogger().info("Performing action: Flush random region of table " + this.tableName);
        List regions = admin.getRegions(this.tableName);
        if (regions == null || regions.isEmpty()) {
            this.getLogger().info("Table " + this.tableName + " doesn't have regions to flush");
            return;
        }
        RegionInfo region = PolicyBasedChaosMonkey.selectRandomItem(regions.toArray(new RegionInfo[0]));
        this.getLogger().debug("Flushing region " + region.getRegionNameAsString());
        try {
            admin.flushRegion(region.getRegionName());
        }
        catch (Exception ex) {
            this.getLogger().warn("Flush failed, might be caused by other chaos: " + ex.getMessage());
        }
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
    }
}

