/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyProc;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaClass;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class InterfaceJavaProxy
extends JavaProxy {
    private static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
            return new InterfaceJavaProxy(runtime2, klazz);
        }
    };

    public InterfaceJavaProxy(Ruby runtime2, RubyClass klazz) {
        super(runtime2, klazz);
    }

    public static RubyClass createInterfaceJavaProxy(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        RubyClass InterfaceJavaProxy2 = runtime2.defineClass("InterfaceJavaProxy", runtime2.getJavaSupport().getJavaProxyClass(), ALLOCATOR);
        RubyClass JavaInterfaceExtended = runtime2.defineClass("JavaInterfaceExtender", runtime2.getObject(), runtime2.getObject().getAllocator());
        JavaInterfaceExtended.defineAnnotatedMethods(JavaInterfaceExtender.class);
        return InterfaceJavaProxy2;
    }

    public static class JavaInterfaceExtender {
        @JRubyMethod(visibility=Visibility.PRIVATE)
        public static IRubyObject initialize(ThreadContext context, IRubyObject self2, IRubyObject javaClassName, Block block) {
            Ruby runtime2 = context.runtime;
            self2.getInstanceVariables().setInstanceVariable("@java_class", JavaClass.forNameVerbose(runtime2, javaClassName.asJavaString()));
            self2.getInstanceVariables().setInstanceVariable("@block", RubyProc.newProc(runtime2, block, block.type));
            self2.getInternalVariables().getInternalVariable("@block");
            return context.nil;
        }

        @JRubyMethod
        public static IRubyObject extend_proxy(ThreadContext context, IRubyObject self2, IRubyObject proxyClass) {
            return proxyClass.callMethod(context, "class_eval", IRubyObject.NULL_ARRAY, ((RubyProc)self2.getInstanceVariables().getInstanceVariable("@block")).getBlock());
        }
    }
}

