/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env;

import io.micronaut.context.env.MapPropertySource;
import io.micronaut.core.order.Ordered;
import java.util.LinkedHashMap;
import java.util.Map;

public interface PropertySource
extends Iterable<String>,
Ordered {
    public static final String CONTEXT = "context";

    public String getName();

    public Object get(String var1);

    default public PropertyConvention getConvention() {
        return PropertyConvention.JAVA_PROPERTIES;
    }

    public static PropertySource of(String name, Map<String, Object> map) {
        return new MapPropertySource(name, map);
    }

    public static PropertySource of(String name, Map<String, Object> map, final PropertyConvention convention) {
        return new MapPropertySource(name, map){

            @Override
            public PropertyConvention getConvention() {
                return convention;
            }
        };
    }

    public static PropertySource of(String name, Object ... values) {
        return new MapPropertySource(name, PropertySource.mapOf(values));
    }

    public static Map<String, Object> mapOf(Object ... values) {
        int len = values.length;
        if (len % 2 != 0) {
            throw new IllegalArgumentException("Number of arguments should be an even number representing the keys and values");
        }
        LinkedHashMap<String, Object> answer = new LinkedHashMap<String, Object>(len / 2);
        int i2 = 0;
        while (i2 < values.length - 1) {
            Object k;
            if ((k = values[i2++]) == null) continue;
            answer.put(k.toString(), values[i2++]);
        }
        return answer;
    }

    public static PropertySource of(String name, Map<String, Object> map, final int priority) {
        return new MapPropertySource(name, map){

            @Override
            public int getOrder() {
                return priority;
            }
        };
    }

    public static PropertySource of(Map<String, Object> map) {
        return new MapPropertySource("application", map);
    }

    public static enum PropertyConvention {
        ENVIRONMENT_VARIABLE,
        JAVA_PROPERTIES;

    }
}

