// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.analysis;

import org.apache.doris.alter.AlterOpType;
import org.apache.doris.common.AnalysisException;

import lombok.Getter;

public class AddPartitionLikeClause extends AlterTableClause {
    @Getter
    private final String partitionName;

    @Getter
    private final String existedPartitionName;

    @Getter
    private final Boolean isTempPartition;

    public AddPartitionLikeClause(String partitionName,
            String existedPartitionName,
            boolean isTempPartition) {
        super(AlterOpType.ADD_PARTITION);
        this.partitionName = partitionName;
        this.existedPartitionName = existedPartitionName;
        this.isTempPartition = isTempPartition;
        this.needTableStable = false;
    }

    @Override
    public void analyze() throws AnalysisException {
    }

    @Override
    public boolean allowOpMTMV() {
        return false;
    }

    @Override
    public boolean needChangeMTMVState() {
        return false;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("ADD PARTITION ").append(partitionName).append(" LIKE ");
        sb.append(existedPartitionName);
        return sb.toString();
    }

    @Override
    public String toString() {
        return toSql();
    }
}
