// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.common.jni.utils;

/**
 * Native method in doris::JavaNativeMethods.
 */
public class JNINativeMethod {
    /**
     * Allocate memory in off heap, which will be tracked by memory tracker.
     */
    public static native long memoryTrackerMalloc(long size);

    /**
     * Free memory in off heap, which will be tracked by memory tracker.
     */
    public static native void memoryTrackerFree(long address);

    /**
     * Allocate multiple off-heap memory blocks in a single JNI call. Each element in sizes
     * corresponds to one allocation. Returns an array of addresses with the same length.
     */
    public static native long[] memoryTrackerMallocBatch(int[] sizes);

    /**
     * Free multiple off-heap memory blocks in a single JNI call. Each element in addrs
     * corresponds to one deallocation.
     */
    public static native void memoryTrackerFreeBatch(long[] addrs);
}
