/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.api.config;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.faces.context.FacesContext;
import java.lang.annotation.Annotation;
import org.apache.deltaspike.core.api.config.DeltaSpikeConfig;
import org.apache.deltaspike.jsf.spi.scope.window.ClientWindowConfig;

@ApplicationScoped
public class JsfModuleConfig
implements DeltaSpikeConfig {
    private static final long serialVersionUID = -487295181899986237L;
    private volatile Boolean initialized;
    private boolean delegatedWindowHandlingEnabled;

    protected JsfModuleConfig() {
    }

    public boolean isInitialRedirectEnabled() {
        return true;
    }

    public boolean isAlwaysKeepMessages() {
        return true;
    }

    public boolean isAlwaysUseNavigationHandlerOnSecurityViolation() {
        return false;
    }

    public ClientWindowConfig.ClientWindowRenderMode getDefaultWindowMode() {
        this.lazyInit();
        if (this.delegatedWindowHandlingEnabled) {
            return ClientWindowConfig.ClientWindowRenderMode.DELEGATED;
        }
        return null;
    }

    public Class<? extends Annotation> getExceptionQualifier() {
        return Default.class;
    }

    public boolean isAllowPostRequestWithoutDoubleSubmitPrevention() {
        return true;
    }

    private void lazyInit() {
        if (this.initialized == null) {
            this.init();
        }
    }

    protected synchronized void init() {
        if (this.initialized == null) {
            String initParam;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            this.delegatedWindowHandlingEnabled = facesContext == null ? false : (initParam = facesContext.getExternalContext().getInitParameter("jakarta.faces.CLIENT_WINDOW_MODE")) != null && !"none".equalsIgnoreCase(initParam.trim());
            this.initialized = true;
        }
    }
}

