/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.ant.task;

import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.torque.ant.task.Option;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.UnitDescriptor;
import org.apache.torque.generator.configuration.controller.Loglevel;
import org.apache.torque.generator.configuration.option.MapOptionsConfiguration;
import org.apache.torque.generator.configuration.option.OptionsConfiguration;
import org.apache.torque.generator.configuration.paths.CustomProjectPaths;
import org.apache.torque.generator.configuration.paths.DefaultTorqueGeneratorPaths;
import org.apache.torque.generator.configuration.paths.Maven2DirectoryProjectPaths;
import org.apache.torque.generator.configuration.paths.Maven2JarProjectPaths;
import org.apache.torque.generator.configuration.paths.ProjectPaths;
import org.apache.torque.generator.configuration.paths.TorqueGeneratorPaths;
import org.apache.torque.generator.control.Controller;
import org.apache.torque.generator.file.Fileset;
import org.apache.torque.generator.source.SourceProvider;
import org.apache.torque.generator.source.stream.FileSourceProvider;

public class TorqueGeneratorTask
extends Task {
    private String packaging = "directory";
    private File projectRootDir = new File(".");
    private File configDir;
    private String configPackage;
    private File sourceDir;
    private Set<String> sourceIncludes;
    private Set<String> sourceExcludes;
    private File defaultOutputDir = new File("target/generated-sources");
    private Map<String, File> outputDirMap = new HashMap<String, File>();
    private String jarFile;
    private File overrideConfigDir;
    private String loglevel;
    private boolean runOnlyOnSourceChange = false;
    private boolean addDebuggingInfoToOutput = false;
    private Charset defaultOutputCharset;
    private Boolean combineFiles;
    private final List<Option> options = new ArrayList<Option>();

    public Option createOption() {
        Option option = new Option();
        this.options.add(option);
        return option;
    }

    /*
     * WARNING - void declaration
     */
    public void execute() throws BuildException {
        void var8_14;
        Maven2JarProjectPaths defaultProjectPaths;
        UnitDescriptor.Packaging packaging;
        Controller controller = new Controller();
        ArrayList<UnitDescriptor> unitDescriptors = new ArrayList<UnitDescriptor>();
        if ("jar".equals(this.packaging)) {
            packaging = UnitDescriptor.Packaging.JAR;
        } else if ("directory".equals(this.packaging)) {
            packaging = UnitDescriptor.Packaging.DIRECTORY;
        } else if ("classpath".equals(this.packaging)) {
            packaging = UnitDescriptor.Packaging.CLASSPATH;
        } else {
            throw new IllegalArgumentException("Unknown packaging " + this.packaging + ", must be jar, directory or classpath");
        }
        this.log("Packaging is " + String.valueOf(packaging), 4);
        if (UnitDescriptor.Packaging.JAR == packaging) {
            defaultProjectPaths = new Maven2JarProjectPaths(this.projectRootDir, this.jarFile);
        } else if (UnitDescriptor.Packaging.DIRECTORY == packaging) {
            defaultProjectPaths = new Maven2DirectoryProjectPaths(this.projectRootDir);
        } else if (UnitDescriptor.Packaging.CLASSPATH == packaging) {
            defaultProjectPaths = new Maven2DirectoryProjectPaths(this.projectRootDir);
        } else {
            throw new IllegalStateException("Unknown packaging" + String.valueOf(packaging));
        }
        CustomProjectPaths projectPaths = new CustomProjectPaths((ProjectPaths)defaultProjectPaths);
        if (UnitDescriptor.Packaging.CLASSPATH == packaging) {
            if (this.configPackage == null) {
                throw new BuildException("configPackage must be set for packaging =\"classpath\"");
            }
            projectPaths.setConfigurationPackage(this.configPackage);
            projectPaths.setConfigurationDir(null);
        } else if (this.configDir != null) {
            projectPaths.setConfigurationDir(this.configDir);
            this.log("Setting config dir to " + this.configDir.toString(), 4);
        }
        if (this.sourceDir != null) {
            projectPaths.setSourceDir(this.sourceDir);
            this.log("Setting source dir to " + this.sourceDir.toString(), 4);
        }
        FileSourceProvider fileSourceProvider = null;
        if (this.sourceIncludes != null || this.sourceExcludes != null) {
            Fileset sourceFileset = new Fileset(projectPaths.getDefaultSourcePath(), this.sourceIncludes, this.sourceExcludes);
            this.log("Setting source includes to " + String.valueOf(this.sourceIncludes), 4);
            this.log("Setting source excludes to " + String.valueOf(this.sourceExcludes), 4);
            try {
                fileSourceProvider = new FileSourceProvider(null, sourceFileset, this.combineFiles);
            }
            catch (ConfigurationException configurationException) {
                throw new BuildException("The source provider cannot be instantiated", (Throwable)configurationException);
            }
        }
        if (this.defaultOutputDir != null) {
            projectPaths.setOutputDirectory(null, this.defaultOutputDir);
            this.log("Setting defaultOutputDir to " + this.defaultOutputDir.getAbsolutePath(), 4);
        }
        if (this.outputDirMap != null) {
            for (Map.Entry entry : this.outputDirMap.entrySet()) {
                projectPaths.setOutputDirectory((String)entry.getKey(), (File)entry.getValue());
                this.log("Setting output directory with key " + (String)entry.getKey() + " to " + String.valueOf(entry.getValue()), 4);
            }
        }
        this.log("ProjectPaths = " + String.valueOf(projectPaths), 4);
        MapOptionsConfiguration optionConfiguration = null;
        if (!this.options.isEmpty()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Option option : this.options) {
                hashMap.put(option.getKey(), option.getValue());
            }
            optionConfiguration = new MapOptionsConfiguration(hashMap);
        }
        Object var8_12 = null;
        if (this.loglevel != null) {
            Loglevel loglevel = Loglevel.getByKey((String)this.loglevel);
        }
        UnitDescriptor unitDescriptor = new UnitDescriptor(packaging, (ProjectPaths)projectPaths, (TorqueGeneratorPaths)new DefaultTorqueGeneratorPaths());
        unitDescriptor.setOverrideSourceProvider((SourceProvider)fileSourceProvider);
        unitDescriptor.setOverrideOptions((OptionsConfiguration)optionConfiguration);
        unitDescriptor.setLoglevel((Loglevel)var8_14);
        unitDescriptor.setRunOnlyOnSourceChange(this.runOnlyOnSourceChange);
        unitDescriptor.setAddDebuggingInfoToOutput(this.addDebuggingInfoToOutput);
        unitDescriptor.setDefaultOutputEncoding(this.defaultOutputCharset);
        this.log("unit descriptor created", 4);
        if (this.overrideConfigDir != null) {
            CustomProjectPaths childProjectPaths = new CustomProjectPaths((ProjectPaths)projectPaths);
            childProjectPaths.setConfigurationDir(this.overrideConfigDir);
            UnitDescriptor parentUnitDescriptor = new UnitDescriptor(UnitDescriptor.Packaging.DIRECTORY, (ProjectPaths)childProjectPaths, (TorqueGeneratorPaths)new DefaultTorqueGeneratorPaths());
            parentUnitDescriptor.setInheritsFrom(unitDescriptor);
            parentUnitDescriptor.setOverrideSourceProvider((SourceProvider)fileSourceProvider);
            parentUnitDescriptor.setOverrideOptions((OptionsConfiguration)optionConfiguration);
            parentUnitDescriptor.setLoglevel((Loglevel)var8_14);
            parentUnitDescriptor.setDefaultOutputEncoding(this.defaultOutputCharset);
            this.log("child unit descriptor created", 4);
            unitDescriptor = parentUnitDescriptor;
        }
        unitDescriptors.add(unitDescriptor);
        try {
            this.log("Generation started", 4);
            controller.run(unitDescriptors);
            this.log("Generation successful", 2);
        }
        catch (Exception e) {
            this.log("Error during generation", e, 0);
            throw new BuildException(e.getMessage());
        }
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public void setProjectRootDir(File projectRootDir) {
        this.projectRootDir = projectRootDir;
    }

    public void setConfigDir(File configDir) {
        this.configDir = configDir;
    }

    public void setConfigPackage(String configPackage) {
        this.configPackage = configPackage;
    }

    public void setDefaultOutputDir(File defaultOutputDir) {
        this.defaultOutputDir = defaultOutputDir;
    }

    public void setOutputDirMap(Map<String, File> outputDirMap) {
        this.outputDirMap = outputDirMap;
    }

    public void setJarFile(String jarFile) {
        this.jarFile = jarFile;
    }

    public void setSourceDir(File sourceDir) {
        this.sourceDir = sourceDir;
    }

    public void setSourceIncludes(Set<String> sourceIncludes) {
        this.sourceIncludes = sourceIncludes;
    }

    public void setSourceExcludes(Set<String> sourceExcludes) {
        this.sourceExcludes = sourceExcludes;
    }

    public void setOverrideConfigDir(File overrideConfigDir) {
        this.overrideConfigDir = overrideConfigDir;
    }

    public void setLoglevel(String loglevel) {
        this.loglevel = loglevel;
    }

    public void setAddDebuggingInfoToOutput(boolean addDebuggingInfoToOutput) {
        this.addDebuggingInfoToOutput = addDebuggingInfoToOutput;
    }

    public void setRunOnlyOnSourceChange(boolean runOnlyOnSourceChange) {
        this.runOnlyOnSourceChange = runOnlyOnSourceChange;
    }

    public void setDefaultOutputEncoding(Charset defaultOutputCharset) {
        this.defaultOutputCharset = defaultOutputCharset;
    }

    public void setCombineFiles(Boolean combineFiles) {
        this.combineFiles = combineFiles;
    }
}

