/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.variable;

import java.util.Objects;
import org.apache.torque.generator.qname.QualifiedName;

public class Variable {
    private final QualifiedName name;
    private Object value;
    private final Scope scope;

    public Variable(QualifiedName name, Object value, Scope scope) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        if (scope == null) {
            throw new NullPointerException("scope must not be null");
        }
        this.name = name;
        this.value = value;
        this.scope = scope;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Scope getScope() {
        return this.scope;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.scope, this.value});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Variable other = (Variable)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals((Object)this.scope, (Object)other.scope)) {
            return false;
        }
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("(name=").append(this.name).append(", value=").append(this.value).append(", scope=").append((Object)this.scope).append(")");
        return result.toString();
    }

    public static enum Scope {
        OUTLET,
        CHILDREN,
        FILE,
        GLOBAL;

    }
}

