/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors.parsers;

import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.schema.annotation.props.gen.LengthUnits;
import org.apache.daffodil.lib.schema.annotation.props.gen.LengthUnits$Bits$;
import org.apache.daffodil.lib.schema.annotation.props.gen.LengthUnits$Bytes$;
import org.apache.daffodil.lib.schema.annotation.props.gen.LengthUnits$Characters$;
import org.apache.daffodil.lib.util.MaybeInt$;
import org.apache.daffodil.lib.util.MaybeULong$;
import org.apache.daffodil.lib.util.Numbers$;
import org.apache.daffodil.lib.util.OKOrError$;
import org.apache.daffodil.runtime1.infoset.DIComplex;
import org.apache.daffodil.runtime1.infoset.DIElement;
import org.apache.daffodil.runtime1.infoset.DISimple;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import org.apache.daffodil.runtime1.infoset.Infoset$;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.ProcessingError;
import org.apache.daffodil.runtime1.processors.SimpleTypeRuntimeData;
import org.apache.daffodil.runtime1.processors.Success$;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import org.apache.daffodil.runtime1.processors.parsers.Parser;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface PrefixedLengthParserMixin {
    public Parser prefixedLengthParser();

    public ElementRuntimeData prefixedLengthERD();

    public LengthUnits lengthUnits();

    public long prefixedLengthAdjustmentInUnits();

    public static long getPrefixedLengthInUnits$(PrefixedLengthParserMixin $this, PState state) {
        return $this.getPrefixedLengthInUnits(state);
    }

    default public long getPrefixedLengthInUnits(PState state) {
        DIElement savedInfoset = state.infoset();
        DISimple plElement = (DISimple)Infoset$.MODULE$.newDetachedElement(state, this.prefixedLengthERD());
        state.infoset_$eq(plElement);
        try {
            this.prefixedLengthParser().parse1(state);
        }
        finally {
            state.infoset_$eq(savedInfoset);
        }
        if (state.processorStatus() == Success$.MODULE$) {
            SimpleTypeRuntimeData strd;
            String check;
            boolean testThatWillThrowIfTrue$proxy4;
            boolean testThatWillThrowIfTrue$proxy3;
            Object object = plElement.dataValue();
            Long parsedLen = Numbers$.MODULE$.asLong(DataValue$.MODULE$.getAnyRef$extension(object));
            PState SDEUsingMacrosMixin_this = state;
            boolean bl = testThatWillThrowIfTrue$proxy3 = Predef$.MODULE$.Long2long(parsedLen) < 0L;
            if (testThatWillThrowIfTrue$proxy3) {
                throw SDEUsingMacrosMixin_this.SDE("Prefixed length result must be non-negative, but was: %d", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{parsedLen}));
            }
            long adjustedLen = Predef$.MODULE$.Long2long(parsedLen) - this.prefixedLengthAdjustmentInUnits();
            PState SDEUsingMacrosMixin_this2 = state;
            boolean bl2 = testThatWillThrowIfTrue$proxy4 = adjustedLen < 0L;
            if (testThatWillThrowIfTrue$proxy4) {
                throw SDEUsingMacrosMixin_this2.SDE("Prefixed length result must be non-negative after dfdl:prefixIncludesPrefixLength adjustment , but was: %d", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)adjustedLen)}));
            }
            Option<SimpleTypeRuntimeData> optSTRD = plElement.erd().optSimpleTypeRuntimeData();
            if (optSTRD.isDefined() && OKOrError$.MODULE$.isError$extension(check = (strd = (SimpleTypeRuntimeData)optSTRD.get()).executeCheck(plElement))) {
                ProcessingError pe = state.toProcessingError("The prefix length value of " + savedInfoset.namedQName() + " (" + parsedLen + ") failed check due to " + check);
                state.setFailed(pe);
            }
            return adjustedLen;
        }
        return 0L;
    }

    public static long getPrefixedLengthInBits$(PrefixedLengthParserMixin $this, PState state) {
        return $this.getPrefixedLengthInBits(state);
    }

    default public long getPrefixedLengthInBits(PState state) {
        long lenInUnits = this.getPrefixedLengthInUnits(state);
        if (state.processorStatus() == Success$.MODULE$) {
            long l;
            LengthUnits lengthUnits = this.lengthUnits();
            if (LengthUnits$Bits$.MODULE$.equals(lengthUnits)) {
                l = lenInUnits;
            } else if (LengthUnits$Bytes$.MODULE$.equals(lengthUnits)) {
                l = lenInUnits * 8L;
            } else if (LengthUnits$Characters$.MODULE$.equals(lengthUnits)) {
                long mfw = state.encoder().bitsCharset().maybeFixedWidth();
                if (!MaybeInt$.MODULE$.isDefined$extension(mfw)) {
                    throw Assert$.MODULE$.abort("Invariant broken: Prefixed length for text data in non-fixed width encoding.(mfw.isDefined)");
                }
                l = lenInUnits * (long)MaybeInt$.MODULE$.get$extension(mfw);
            } else {
                throw new MatchError((Object)lengthUnits);
            }
            long lenInBits = l;
            long mLenInBits = MaybeULong$.MODULE$.apply(lenInBits);
            DIElement dIElement = state.infoset();
            if (dIElement instanceof DIComplex) {
                DIComplex ci = (DIComplex)dIElement;
                ci.contentLength().maybeComputedLengthInBits_$eq(mLenInBits);
                ci.valueLength().maybeComputedLengthInBits_$eq(mLenInBits);
            } else if (dIElement instanceof DISimple) {
                DISimple si = (DISimple)dIElement;
                si.contentLength().maybeComputedLengthInBits_$eq(mLenInBits);
            } else {
                throw new MatchError((Object)dIElement);
            }
            return lenInBits;
        }
        return 0L;
    }
}

