/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.Properties;
import java.util.Stack;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceDeltaMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;

public class NamespaceDifferencer
extends ProxyReceiver {
    private boolean undeclareNamespaces = false;
    private final Stack<NamespaceMap> namespaceStack = new Stack();

    public NamespaceDifferencer(Receiver next) {
        super(next);
        this.namespaceStack.push(NamespaceMap.emptyMap());
    }

    public NamespaceDifferencer(Receiver next, Properties details) {
        this(next);
        this.undeclareNamespaces = "yes".equals(details.getProperty("undeclare-prefixes"));
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        NamespaceMap parentMap = this.namespaceStack.peek();
        this.namespaceStack.push(namespaces);
        NamespaceMap delta = this.getDifferences(namespaces, parentMap, elemName.hasURI(NamespaceUri.NULL));
        this.nextReceiver.startElement(elemName, type, attributes, delta, location, properties);
    }

    @Override
    public void endElement() throws XPathException {
        this.namespaceStack.pop();
        super.endElement();
    }

    private NamespaceMap getDifferences(NamespaceMap thisMap, NamespaceMap parentMap, boolean elementInDefaultNamespace) throws XPathException {
        if (thisMap != parentMap) {
            NamespaceMap delta = NamespaceDeltaMap.emptyMap();
            for (NamespaceBinding nb : thisMap) {
                NamespaceUri parentUri = parentMap.getNamespaceUri(nb.getPrefix());
                if (parentUri == null) {
                    delta = ((NamespaceMap)delta).put(nb.getPrefix(), nb.getNamespaceUri());
                    continue;
                }
                if (parentUri.equals(nb.getNamespaceUri())) continue;
                delta = ((NamespaceMap)delta).put(nb.getPrefix(), nb.getNamespaceUri());
            }
            if (this.undeclareNamespaces) {
                for (NamespaceBinding nb : parentMap) {
                    if (thisMap.getNamespaceUri(nb.getPrefix()) != null) continue;
                    delta = ((NamespaceMap)delta).put(nb.getPrefix(), NamespaceUri.NULL);
                }
            } else if (!parentMap.getDefaultNamespace().isEmpty() && thisMap.getDefaultNamespace().isEmpty()) {
                delta = ((NamespaceMap)delta).put("", NamespaceUri.NULL);
            }
            return delta;
        }
        return NamespaceMap.emptyMap();
    }
}

