/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.version.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.apache.activemq.artemis.core.version.Version;

public class VersionImpl
implements Version,
Serializable {
    private static final long serialVersionUID = -5271227256591080403L;
    private final String versionName;
    private final int majorVersion;
    private final int minorVersion;
    private final int microVersion;
    private final int incrementingVersion;
    private final int[] compatibleVersionList;

    public VersionImpl(String versionName, int majorVersion, int minorVersion, int microVersion, int incrementingVersion, int[] compatibleVersionList) {
        this.versionName = versionName;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.microVersion = microVersion;
        this.incrementingVersion = incrementingVersion;
        this.compatibleVersionList = Arrays.copyOf(compatibleVersionList, compatibleVersionList.length);
    }

    @Override
    public String getFullVersion() {
        return this.versionName;
    }

    @Override
    public String getVersionName() {
        return this.versionName;
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public int getMicroVersion() {
        return this.microVersion;
    }

    @Override
    public int getIncrementingVersion() {
        return this.incrementingVersion;
    }

    @Override
    public boolean isCompatible(int version) {
        for (int element : this.compatibleVersionList) {
            if (element != version) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.compatibleVersionList), this.incrementingVersion, this.majorVersion, this.microVersion, this.minorVersion, this.versionName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VersionImpl)) {
            return false;
        }
        VersionImpl other = (VersionImpl)obj;
        return Arrays.equals(this.compatibleVersionList, other.compatibleVersionList) && this.incrementingVersion == other.incrementingVersion && this.majorVersion == other.majorVersion && this.microVersion == other.microVersion && this.minorVersion == other.minorVersion && Objects.equals(this.versionName, other.versionName);
    }
}

