/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JType;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JCommentPart
extends ArrayList<Object> {
    private static final long serialVersionUID = 1L;
    private static final List<AbstractMap.SimpleImmutableEntry<String, String>> ESCAPED_XML_JAVADOC = new ArrayList<AbstractMap.SimpleImmutableEntry<String, String>>();

    protected JCommentPart() {
    }

    public JCommentPart append(Object o) {
        this.add(o);
        return this;
    }

    public JCommentPart appendXML(String s) {
        this.add(this.escapeXML(s));
        return this;
    }

    @Override
    public boolean add(Object o) {
        this.flattenAppend(o);
        return true;
    }

    private void flattenAppend(Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Object[]) {
            for (Object o : (Object[])value) {
                this.flattenAppend(o);
            }
        } else if (value instanceof Collection) {
            for (Object o : (Collection)value) {
                this.flattenAppend(o);
            }
        } else {
            super.add(value);
        }
    }

    protected void format(JFormatter f, String indent) {
        if (!f.isPrinting()) {
            for (Object o : this) {
                if (!(o instanceof JClass)) continue;
                f.g((JClass)o);
            }
            return;
        }
        if (!this.isEmpty()) {
            f.p(indent);
        }
        for (Object o : this) {
            if (o instanceof String) {
                int idx;
                String s = (String)o;
                while ((idx = s.indexOf(10)) != -1) {
                    String line = s.substring(0, idx);
                    if (line.length() > 0) {
                        f.p(this.escape(line));
                    }
                    s = s.substring(idx + 1);
                    f.nl().p(indent);
                }
                if (s.length() == 0) continue;
                f.p(this.escape(s));
                continue;
            }
            if (o instanceof JClass) {
                ((JClass)o).printLink(f);
                continue;
            }
            if (o instanceof JType) {
                f.g((JType)o);
                continue;
            }
            throw new IllegalStateException();
        }
        if (!this.isEmpty()) {
            f.nl();
        }
    }

    private String escapeXML(String s) {
        if (s == null) {
            return s;
        }
        for (AbstractMap.SimpleImmutableEntry<String, String> entry : ESCAPED_XML_JAVADOC) {
            int entryKeyLength = entry.getKey().length();
            int entryValueLength = entry.getValue().length();
            int idx = -1;
            while ((idx = ((String)s).indexOf(entry.getKey(), idx)) >= 0) {
                s = ((String)s).substring(0, idx) + entry.getValue() + ((String)s).substring(idx + entryKeyLength);
                idx += entryValueLength;
            }
        }
        return s;
    }

    private String escape(String s) {
        int idx;
        while ((idx = ((String)s).indexOf("*/")) >= 0) {
            s = ((String)s).substring(0, idx + 1) + "<!---->" + ((String)s).substring(idx + 1);
        }
        return s;
    }

    static {
        ESCAPED_XML_JAVADOC.add(new AbstractMap.SimpleImmutableEntry<String, String>("&", "&amp;"));
        ESCAPED_XML_JAVADOC.add(new AbstractMap.SimpleImmutableEntry<String, String>("<", "&lt;"));
        ESCAPED_XML_JAVADOC.add(new AbstractMap.SimpleImmutableEntry<String, String>(">", "&gt;"));
        ESCAPED_XML_JAVADOC.add(new AbstractMap.SimpleImmutableEntry<String, String>("@", "&#064;"));
    }
}

