/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import org.apache.activemq.artemis.core.config.impl.Validators;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLConfigurationUtil {
    public static final String getAttributeValue(Node element, String attribute) {
        Node node = element.getAttributes().getNamedItem(attribute);
        if (node == null) {
            return null;
        }
        return node.getNodeValue();
    }

    public static final String getTrimmedTextContent(Node element) {
        String content = element.getTextContent();
        if (content == null) {
            return null;
        }
        return content.trim();
    }

    public static final Double getDouble(Element e, String name, double def, Validators.Validator<Number> validator) {
        NodeList nl = e.getElementsByTagName(name);
        if (nl.getLength() > 0) {
            return (Double)validator.validate(name, XMLUtil.parseDouble((Node)nl.item(0)));
        }
        return def;
    }

    public static final String getString(Element e, String name, String def, Validators.Validator<String> validator) {
        NodeList nl = e.getElementsByTagName(name);
        if (nl.getLength() > 0) {
            return validator.validate(name, nl.item(0).getTextContent().trim());
        }
        return def;
    }

    public static final Long getLong(Element e, String name, long def, Validators.Validator<Number> validator) {
        return XMLConfigurationUtil.getLong(e, name, def, validator, null);
    }

    public static final Long getLong(Element e, String name, long def, Validators.Validator<Number> validator, String alternativeForDeprecated) {
        NodeList nl = e.getElementsByTagName(name);
        if (nl.getLength() > 0) {
            if (alternativeForDeprecated != null) {
                ActiveMQServerLogger.LOGGER.deprecatedConfigurationOption(name, alternativeForDeprecated);
            }
            return (Long)validator.validate(name, XMLUtil.parseLong((Node)nl.item(0)));
        }
        return def;
    }

    public static final Long getTextBytesAsLongBytes(Element e, String name, long def, Validators.Validator<Number> validator) {
        NodeList nl = e.getElementsByTagName(name);
        if (nl.getLength() > 0) {
            return (Long)validator.validate(name, ByteUtil.convertTextBytes((String)nl.item(0).getTextContent().trim()));
        }
        return def;
    }

    public static final Integer getAttributeInteger(Element e, String name, Integer def, Validators.Validator<Number> validator) {
        String attribute = e.getAttribute(name);
        if (attribute != null && !attribute.isEmpty()) {
            return (Integer)validator.validate(name, XMLUtil.parseInt((Node)e, (String)attribute));
        }
        return def;
    }

    public static final Integer getInteger(Element e, String name, Integer def, Validators.Validator<Number> validator) {
        NodeList nl = e.getElementsByTagName(name);
        if (nl.getLength() > 0) {
            return (Integer)validator.validate(name, XMLUtil.parseInt((Node)nl.item(0)));
        }
        return def;
    }

    public static final Integer getTextBytesAsIntBytes(Element e, String name, int def, Validators.Validator<Number> validator) {
        return XMLConfigurationUtil.getTextBytesAsLongBytes(e, name, def, validator).intValue();
    }

    public static final Boolean getBoolean(Element e, String name, Boolean def) {
        NodeList nl = e.getElementsByTagName(name);
        if (nl.getLength() > 0) {
            return XMLUtil.parseBoolean((Node)nl.item(0));
        }
        return def;
    }

    public static final Boolean getBooleanAttribute(Element e, String name, Boolean def) {
        String attributeValue = e.getAttribute(name);
        if (attributeValue == null || attributeValue.isEmpty()) {
            return def;
        }
        return Boolean.parseBoolean(attributeValue);
    }

    public static final Boolean parameterExists(Element e, String name) {
        NodeList nl = e.getElementsByTagName(name);
        if (nl.getLength() > 0) {
            return true;
        }
        return false;
    }
}

