/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.net;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.net.ThreadLocalHttpServletRequestProxy;
import net.shibboleth.utilities.java.support.net.ThreadLocalHttpServletResponseProxy;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.NonnullSupplier;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CookieManager
extends AbstractInitializableComponent {
    private final Logger log = LoggerFactory.getLogger(CookieManager.class);
    @Nullable
    private String cookiePath;
    @Nullable
    private String cookieDomain;
    @NonnullAfterInit
    private NonnullSupplier<HttpServletRequest> httpRequestSupplier;
    @NonnullAfterInit
    private NonnullSupplier<HttpServletResponse> httpResponseSupplier;
    private boolean secure = true;
    private boolean httpOnly = true;
    private int maxAge = -1;

    public void setCookiePath(@Nullable String path) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        this.cookiePath = StringSupport.trimOrNull(path);
    }

    public void setCookieDomain(@Nullable String domain) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        this.cookieDomain = StringSupport.trimOrNull(domain);
    }

    public void setHttpServletRequestSupplier(@Nonnull NonnullSupplier<HttpServletRequest> requestSupplier) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        this.httpRequestSupplier = Constraint.isNotNull(requestSupplier, "HttpServletRequest cannot be null");
    }

    @Deprecated(since="4.3", forRemoval=true)
    public void setHttpServletRequest(final @Nullable HttpServletRequest request) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        DeprecationSupport.warnOnce(DeprecationSupport.ObjectType.METHOD, "setHttpServletReqest", "CookieManager", "setHttpServletRequestSupplier");
        if (request != null && !(request instanceof ThreadLocalHttpServletRequestProxy)) {
            this.log.warn("Unsafe HttpServletRequest injected");
        }
        this.httpRequestSupplier = new NonnullSupplier<HttpServletRequest>(){

            @Override
            public HttpServletRequest get() {
                return request;
            }
        };
    }

    @NonnullAfterInit
    private HttpServletRequest getHttpServletRequest() {
        if (this.httpRequestSupplier == null) {
            return null;
        }
        return this.httpRequestSupplier.get();
    }

    public void setHttpServletResponseSupplier(@Nonnull NonnullSupplier<HttpServletResponse> responseSupplier) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        this.httpResponseSupplier = Constraint.isNotNull(responseSupplier, "HttpServletResponse cannot be null");
    }

    @Deprecated(since="4.3", forRemoval=true)
    public void setHttpServletResponse(final @Nullable HttpServletResponse response) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        DeprecationSupport.warnOnce(DeprecationSupport.ObjectType.METHOD, "setHttpServletResponse", "CookieManager", "setHttpServletResponseSupplier");
        if (response != null && !(response instanceof ThreadLocalHttpServletResponseProxy)) {
            this.log.warn("Unsafe HttpServletRequest injected");
        }
        this.httpResponseSupplier = new NonnullSupplier<HttpServletResponse>(){

            @Override
            public HttpServletResponse get() {
                return response;
            }
        };
    }

    @NonnullAfterInit
    private HttpServletResponse getHttpServletResponse() {
        if (this.httpResponseSupplier == null) {
            return null;
        }
        return this.httpResponseSupplier.get();
    }

    public void setSecure(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        this.secure = flag;
    }

    public void setHttpOnly(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        this.httpOnly = flag;
    }

    public void setMaxAge(int age) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        this.maxAge = age;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.httpRequestSupplier == null || this.httpResponseSupplier == null) {
            throw new ComponentInitializationException("Servlet request and response must be set");
        }
    }

    public void addCookie(@Nonnull @NotEmpty String name, @Nonnull @NotEmpty String value) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(this.cookiePath != null ? this.cookiePath : this.contextPathToCookiePath());
        if (this.cookieDomain != null) {
            cookie.setDomain(this.cookieDomain);
        }
        cookie.setSecure(this.secure);
        cookie.setHttpOnly(this.httpOnly);
        cookie.setMaxAge(this.maxAge);
        this.getHttpServletResponse().addCookie(cookie);
    }

    public void unsetCookie(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        Cookie cookie = new Cookie(name, null);
        cookie.setPath(this.cookiePath != null ? this.cookiePath : this.contextPathToCookiePath());
        if (this.cookieDomain != null) {
            cookie.setDomain(this.cookieDomain);
        }
        cookie.setSecure(this.secure);
        cookie.setHttpOnly(this.httpOnly);
        cookie.setMaxAge(0);
        this.getHttpServletResponse().addCookie(cookie);
    }

    public boolean cookieHasValue(@Nonnull @NotEmpty String name, @Nonnull @NotEmpty String expectedValue) {
        String realValue = this.getCookieValue(name, null);
        if (realValue == null) {
            return false;
        }
        return realValue.equals(expectedValue);
    }

    @Nullable
    public String getCookieValue(@Nonnull @NotEmpty String name, @Nullable String defValue) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        Cookie[] cookies = this.getHttpServletRequest().getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie.getValue();
            }
        }
        return defValue;
    }

    @Nonnull
    @NotEmpty
    private String contextPathToCookiePath() {
        HttpServletRequest httpRequest = this.getHttpServletRequest();
        return "".equals(httpRequest.getContextPath()) ? "/" : httpRequest.getContextPath();
    }
}

