/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import org.jgroups.Address;
import org.jgroups.BytesMessage;
import org.jgroups.Message;
import org.jgroups.MessageFactory;
import org.jgroups.annotations.MBean;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.stack.Protocol;
import org.jgroups.util.ByteArray;
import org.jgroups.util.FastArray;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

@MBean(description="Serializes entire message into the payload of another message")
public class SERIALIZE
extends Protocol {
    protected static final short GMS_ID = ClassConfigurator.getProtocolId(GMS.class);
    protected MessageFactory mf;

    @Override
    public void init() throws Exception {
        super.init();
        this.mf = this.getTransport().getMessageFactory();
    }

    @Override
    public Object down(Message msg) {
        GMS.GmsHeader hdr;
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
        ByteArray serialized_msg = null;
        try {
            serialized_msg = Util.messageToBuffer(msg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Message tmp = new BytesMessage(msg.dest(), serialized_msg).setFlag(msg.getFlags(), false);
        if (msg.isFlagSet(Message.TransientFlag.DONT_LOOPBACK)) {
            tmp.setFlag(Message.TransientFlag.DONT_LOOPBACK);
        }
        if ((hdr = (GMS.GmsHeader)msg.getHeader(GMS_ID)) != null) {
            tmp.putHeader(GMS_ID, hdr);
        }
        return this.down_prot.down(tmp);
    }

    @Override
    public Object up(Message msg) {
        try {
            Message ret = this.deserialize(msg.src(), msg.getArray(), msg.getOffset(), msg.getLength());
            return this.up_prot.up(ret);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("failed deserialize message from %s", msg.getSrc()), e);
        }
    }

    @Override
    public void up(MessageBatch batch) {
        FastArray.FastIterator it = (FastArray.FastIterator)batch.iterator();
        while (it.hasNext()) {
            Message msg = (Message)it.next();
            try {
                Message deserialized_msg = this.deserialize(msg.src(), msg.getArray(), msg.getOffset(), msg.getLength());
                it.replace(deserialized_msg);
            }
            catch (Exception e) {
                this.log.error("failed deserializing message", e);
                it.remove();
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected Message deserialize(Address sender, byte[] buf, int offset, int length) throws Exception {
        try {
            Message msg = Util.messageFromBuffer(buf, offset, length, this.mf);
            if (msg.getDest() == null) {
                msg.setDest(msg.getDest());
            }
            if (msg.getSrc() == null) {
                msg.setSrc(msg.getSrc());
            }
            return msg;
        }
        catch (Exception e) {
            throw new Exception(String.format("failed deserialize message from %s", sender), e);
        }
    }
}

