/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.config.builders;

import java.util.HashSet;
import java.util.Set;
import org.ehcache.config.Builder;
import org.ehcache.impl.config.executor.PooledExecutionServiceConfiguration;

public class PooledExecutionServiceConfigurationBuilder
implements Builder<PooledExecutionServiceConfiguration> {
    private Pool defaultPool;
    private final Set<Pool> pools = new HashSet<Pool>();

    private PooledExecutionServiceConfigurationBuilder() {
    }

    private PooledExecutionServiceConfigurationBuilder(PooledExecutionServiceConfigurationBuilder other) {
        this.defaultPool = other.defaultPool;
        this.pools.addAll(other.pools);
    }

    private PooledExecutionServiceConfigurationBuilder(PooledExecutionServiceConfiguration seed) {
        seed.getPoolConfigurations().forEach((alias, config) -> {
            Pool pool = new Pool((String)alias, config.minSize(), config.maxSize());
            if (alias.equals(seed.getDefaultPoolAlias())) {
                this.defaultPool = pool;
            }
            this.pools.add(pool);
        });
    }

    public static PooledExecutionServiceConfigurationBuilder newPooledExecutionServiceConfigurationBuilder() {
        return new PooledExecutionServiceConfigurationBuilder();
    }

    public static PooledExecutionServiceConfigurationBuilder newPooledExecutionServiceConfigurationBuilder(PooledExecutionServiceConfiguration seed) {
        return new PooledExecutionServiceConfigurationBuilder(seed);
    }

    public PooledExecutionServiceConfigurationBuilder defaultPool(String alias, int minSize, int maxSize) {
        PooledExecutionServiceConfigurationBuilder other = new PooledExecutionServiceConfigurationBuilder(this);
        other.defaultPool = new Pool(alias, minSize, maxSize);
        return other;
    }

    public PooledExecutionServiceConfigurationBuilder pool(String alias, int minSize, int maxSize) {
        PooledExecutionServiceConfigurationBuilder other = new PooledExecutionServiceConfigurationBuilder(this);
        other.pools.add(new Pool(alias, minSize, maxSize));
        return other;
    }

    @Override
    public PooledExecutionServiceConfiguration build() {
        PooledExecutionServiceConfiguration config = new PooledExecutionServiceConfiguration();
        if (this.defaultPool != null) {
            config.addDefaultPool(this.defaultPool.alias, this.defaultPool.minSize, this.defaultPool.maxSize);
        }
        for (Pool pool : this.pools) {
            config.addPool(pool.alias, pool.minSize, pool.maxSize);
        }
        return config;
    }

    private static class Pool {
        private final String alias;
        private final int minSize;
        private final int maxSize;

        Pool(String alias, int minSize, int maxSize) {
            this.alias = alias;
            this.minSize = minSize;
            this.maxSize = maxSize;
        }
    }
}

