/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.loaderwriter.writebehind;

import org.ehcache.impl.internal.loaderwriter.writebehind.WriteBehind;
import org.ehcache.impl.internal.loaderwriter.writebehind.operations.DeleteOperation;
import org.ehcache.impl.internal.loaderwriter.writebehind.operations.SingleOperation;
import org.ehcache.impl.internal.loaderwriter.writebehind.operations.WriteOperation;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.loaderwriter.CacheWritingException;

abstract class AbstractWriteBehind<K, V>
implements WriteBehind<K, V> {
    private final CacheLoaderWriter<K, V> cacheLoaderWriter;

    public AbstractWriteBehind(CacheLoaderWriter<K, V> cacheLoaderWriter) {
        this.cacheLoaderWriter = cacheLoaderWriter;
    }

    @Override
    public V load(K key) throws Exception {
        SingleOperation<K, V> operation = this.getOperation(key);
        return (V)(operation == null ? this.cacheLoaderWriter.load(key) : (operation.getClass() == WriteOperation.class ? ((WriteOperation)operation).getValue() : null));
    }

    @Override
    public void write(K key, V value) throws CacheWritingException {
        this.addOperation(new WriteOperation<K, V>(key, value));
    }

    @Override
    public void delete(K key) throws CacheWritingException {
        this.addOperation(new DeleteOperation(key));
    }

    protected abstract SingleOperation<K, V> getOperation(K var1);

    protected abstract void addOperation(SingleOperation<K, V> var1);
}

