/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Logger;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.rs.security.saml.AbstractSamlOutInterceptor;
import org.apache.cxf.rs.security.saml.SAMLUtils;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.util.DOM2Writer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SamlFormOutInterceptor
extends AbstractSamlOutInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(SamlFormOutInterceptor.class);
    private static final String SAML_ELEMENT = "SAMLToken";

    public SamlFormOutInterceptor() {
        this("write");
    }

    public SamlFormOutInterceptor(String phase) {
        super(phase);
    }

    public void handleMessage(Message message) throws Fault {
        Form form = this.getRequestForm(message);
        if (form == null) {
            return;
        }
        try {
            SamlAssertionWrapper assertionWrapper = SAMLUtils.createAssertion(message);
            Document doc = DOMUtils.newDocument();
            Element assertionElement = assertionWrapper.toDOM(doc);
            String encodedToken = this.encodeToken(DOM2Writer.nodeToString((Node)assertionElement));
            this.updateForm(form, encodedToken);
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            LOG.warning(sw.toString());
            throw new Fault((Throwable)new RuntimeException(ex.getMessage() + ", stacktrace: " + sw.toString()));
        }
    }

    protected void updateForm(Form form, String encodedToken) {
        form.param(SAML_ELEMENT, encodedToken);
    }

    protected Form getRequestForm(Message message) {
        Object ct = message.get((Object)"Content-Type");
        if (ct == null || !"application/x-www-form-urlencoded".equalsIgnoreCase(ct.toString())) {
            return null;
        }
        MessageContentsList objs = MessageContentsList.getContentsList((Message)message);
        if (objs != null && objs.size() == 1) {
            Object obj = objs.get(0);
            if (obj instanceof Form) {
                return (Form)obj;
            }
            if (obj instanceof MultivaluedMap) {
                return new Form((MultivaluedMap)obj);
            }
        }
        return null;
    }
}

