/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import java.net.URI;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenGrant;

@MappedSuperclass
public class AuthorizationCodeGrant
implements AccessTokenGrant {
    private static final long serialVersionUID = -3738825769770411453L;
    private String code;
    private String redirectUri;
    private String codeVerifier;

    public AuthorizationCodeGrant() {
    }

    public AuthorizationCodeGrant(String code) {
        this.code = code;
    }

    public AuthorizationCodeGrant(String code, URI uri) {
        this.code = code;
        this.redirectUri = uri.toString();
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    @Id
    public String getCode() {
        return this.code;
    }

    public void setCode(String c) {
        this.code = c;
    }

    @Override
    @Transient
    public String getType() {
        return "authorization_code";
    }

    @Override
    public MultivaluedMap<String, String> toMap() {
        MetadataMap map = new MetadataMap();
        map.putSingle((Object)"grant_type", (Object)"authorization_code");
        map.putSingle((Object)"code", (Object)this.getCode());
        if (this.getRedirectUri() != null) {
            map.putSingle((Object)"redirect_uri", (Object)this.getRedirectUri());
        }
        if (this.getCodeVerifier() != null) {
            map.putSingle((Object)"code_verifier", (Object)this.getCodeVerifier());
        }
        return map;
    }

    public String getCodeVerifier() {
        return this.codeVerifier;
    }

    public void setCodeVerifier(String codeVerifier) {
        this.codeVerifier = codeVerifier;
    }
}

