/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.rat.ConfigurationException;
import org.apache.rat.DeprecationReporter;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.commandline.Arg;
import org.apache.rat.commandline.ArgumentContext;
import org.apache.rat.commandline.StyleSheets;
import org.apache.rat.config.exclusion.StandardCollection;
import org.apache.rat.document.DocumentName;
import org.apache.rat.document.DocumentNameMatcher;
import org.apache.rat.document.FileDocument;
import org.apache.rat.help.Licenses;
import org.apache.rat.license.LicenseSetFactory;
import org.apache.rat.report.IReportable;
import org.apache.rat.report.claim.ClaimStatistic;
import org.apache.rat.utils.DefaultLog;
import org.apache.rat.utils.Log;
import org.apache.rat.walker.ArchiveWalker;
import org.apache.rat.walker.DirectoryWalker;

public final class OptionCollection {
    public static final Comparator<Option> OPTION_COMPARATOR = new OptionComparator();
    public static final Option HELP = new Option("?", "help", false, "Print help for the RAT command line interface and exit.");
    @Deprecated
    private static final Map<String, Supplier<String>> ARGUMENT_TYPES = new TreeMap<String, Supplier<String>>();

    private OptionCollection() {
    }

    @Deprecated
    public static Map<String, Supplier<String>> getArgumentTypes() {
        return Collections.unmodifiableMap(ARGUMENT_TYPES);
    }

    private static String asString(Object[] args) {
        return Arrays.stream(args).map(Object::toString).collect(Collectors.joining(", "));
    }

    public static ReportConfiguration parseCommands(File workingDirectory, String[] args, Consumer<Options> helpCmd) throws IOException {
        return OptionCollection.parseCommands(workingDirectory, args, helpCmd, false);
    }

    public static ReportConfiguration parseCommands(File workingDirectory, String[] args, Consumer<Options> helpCmd, boolean noArgs) throws IOException {
        CommandLine commandLine;
        Options opts = OptionCollection.buildOptions();
        try {
            commandLine = DefaultParser.builder().setDeprecatedHandler(DeprecationReporter.getLogReporter()).setAllowPartialMatching(true).build().parse(opts, args);
        }
        catch (ParseException e) {
            DefaultLog.getInstance().error(e.getMessage());
            DefaultLog.getInstance().error("Please use the \"--help\" option to see a list of valid commands and options.", e);
            System.exit(1);
            return null;
        }
        Arg.processLogLevel(commandLine);
        ArgumentContext argumentContext = new ArgumentContext(workingDirectory, commandLine);
        if (commandLine.hasOption(HELP)) {
            helpCmd.accept(opts);
            return null;
        }
        if (commandLine.hasOption(Arg.HELP_LICENSES.option())) {
            new Licenses(OptionCollection.createConfiguration(argumentContext), new PrintWriter(System.out)).printHelp();
            return null;
        }
        ReportConfiguration configuration = OptionCollection.createConfiguration(argumentContext);
        if (!noArgs && !configuration.hasSource()) {
            String msg = "No directories or files specified for scanning. Did you forget to close a multi-argument option?";
            DefaultLog.getInstance().error(msg);
            helpCmd.accept(opts);
            throw new ConfigurationException(msg);
        }
        return configuration;
    }

    static ReportConfiguration createConfiguration(ArgumentContext argumentContext) {
        argumentContext.processArgs();
        ReportConfiguration configuration = argumentContext.getConfiguration();
        CommandLine commandLine = argumentContext.getCommandLine();
        if (Arg.DIR.isSelected()) {
            try {
                configuration.addSource(OptionCollection.getReportable((File)commandLine.getParsedOptionValue(Arg.DIR.getSelected()), configuration));
            }
            catch (ParseException e) {
                throw new ConfigurationException("Unable to set parse " + Arg.DIR.getSelected(), e);
            }
        }
        for (String s : commandLine.getArgs()) {
            IReportable reportable = OptionCollection.getReportable(new File(s), configuration);
            if (reportable == null) continue;
            configuration.addSource(reportable);
        }
        return configuration;
    }

    public static Options buildOptions() {
        return Arg.getOptions().addOption(HELP);
    }

    static IReportable getReportable(File base, ReportConfiguration config) {
        FileDocument doc;
        File absBase = base.getAbsoluteFile();
        DocumentName documentName = DocumentName.builder(absBase).build();
        if (!absBase.exists()) {
            DefaultLog.getInstance().error("Directory '" + documentName + "' does not exist.");
            return null;
        }
        DocumentNameMatcher documentExcluder = config.getDocumentExcluder(documentName);
        if (!documentExcluder.matches((doc = new FileDocument(documentName, absBase, documentExcluder)).getName())) {
            DefaultLog.getInstance().error("Directory '" + documentName + "' is in excluded list.");
            return null;
        }
        if (absBase.isDirectory()) {
            return new DirectoryWalker(doc);
        }
        return new ArchiveWalker(doc);
    }

    static {
        for (ArgumentType argType : ArgumentType.values()) {
            ARGUMENT_TYPES.put(argType.getDisplayName(), argType.description);
        }
    }

    private static final class OptionComparator
    implements Comparator<Option>,
    Serializable {
        private static final long serialVersionUID = 5305467873966684014L;

        private OptionComparator() {
        }

        private String getKey(Option opt) {
            String key = opt.getOpt();
            key = key == null ? opt.getLongOpt() : key;
            return key;
        }

        @Override
        public int compare(Option opt1, Option opt2) {
            return this.getKey(opt1).compareToIgnoreCase(this.getKey(opt2));
        }
    }

    public static enum ArgumentType {
        FILE("File", () -> "A file name."),
        INTEGER("Integer", () -> "An integer value."),
        DIRORARCHIVE("DirOrArchive", () -> "A directory or archive file to scan."),
        EXPRESSION("Expression", () -> "A file matching pattern usually of the form used in Ant build files and '.gitignore' files (see https://ant.apache.org/manual/dirtasks.html#patterns for examples). Regular expression patterns may be specified by surrounding the pattern with '%regex[' and ']'. For example '%regex[[A-Z].*]' would match files and directories that start with uppercase latin letters."),
        LICENSEFILTER("LicenseFilter", () -> String.format("A defined filter for the licenses to include. Valid values: %s.", OptionCollection.asString((Object[])LicenseSetFactory.LicenseFilter.values()))),
        LOGLEVEL("LogLevel", () -> String.format("The log level to use. Valid values %s.", OptionCollection.asString((Object[])Log.Level.values()))),
        PROCESSINGTYPE("ProcessingType", () -> String.format("Specifies how to process file types. Valid values are: %s%n", Arrays.stream(ReportConfiguration.Processing.values()).map(v -> String.format("\t%s: %s", v.name(), v.desc())).collect(Collectors.joining(System.lineSeparator())))),
        STYLESHEET("StyleSheet", () -> String.format("Either an external xsl file or one of the internal named sheets. Internal sheets are: %n%s", Arrays.stream(StyleSheets.values()).map(v -> String.format("\t%s: %s%n", v.arg(), v.desc())).collect(Collectors.joining(System.lineSeparator())))),
        LICENSEID("LicenseID", () -> "The ID for a license."),
        FAMILYID("FamilyID", () -> "The ID for a license family."),
        STANDARDCOLLECTION("StandardCollection", () -> String.format("Defines standard expression patterns (see above). Valid values are: %n%s%n", Arrays.stream(StandardCollection.values()).map(v -> String.format("\t%s: %s%n", v.name(), v.desc())).collect(Collectors.joining(System.lineSeparator())))),
        COUNTERPATTERN("CounterPattern", () -> String.format("A pattern comprising one of the following prefixes followed by a colon and a count (e.g. %s:5).  Prefixes are %n%s.", new Object[]{ClaimStatistic.Counter.UNAPPROVED, Arrays.stream(ClaimStatistic.Counter.values()).map(v -> String.format("\t%s: %s Default range [%s, %s]%n", v.name(), v.getDescription(), v.getDefaultMinValue(), v.getDefaultMaxValue() == -1 ? "unlimited" : Integer.valueOf(v.getDefaultMaxValue()))).collect(Collectors.joining(System.lineSeparator()))})),
        ARG("Arg", () -> "A string"),
        NONE("", () -> "");

        private final String displayName;
        private final Supplier<String> description;

        private ArgumentType(String name, Supplier<String> description) {
            this.displayName = name;
            this.description = description;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Supplier<String> description() {
            return this.description;
        }
    }
}

