/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.beans;

import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathAbstractFactoryException;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathInvalidAccessException;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.NullPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyOwnerPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;

public class NullPropertyPointer
extends PropertyPointer {
    private static final long serialVersionUID = 5296593071854982754L;
    private String propertyName = "*";
    private boolean byNameAttribute;

    public NullPropertyPointer(NodePointer parent) {
        super(parent);
    }

    @Override
    public String asPath() {
        if (!this.byNameAttribute) {
            return super.asPath();
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getImmediateParentPointer().asPath());
        buffer.append("[@name='");
        buffer.append(this.escape(this.getPropertyName()));
        buffer.append("']");
        if (this.index != Integer.MIN_VALUE) {
            buffer.append('[').append(this.index + 1).append(']');
        }
        return buffer.toString();
    }

    private JXPathAbstractFactoryException createBadFactoryException(AbstractFactory factory) {
        return new JXPathAbstractFactoryException("Factory " + factory + " reported success creating object for path: " + this.asPath() + " but object was null.  Terminating to avoid stack recursion.");
    }

    @Override
    public NodePointer createChild(JXPathContext context, QName qName, int index) {
        return this.createPath(context).createChild(context, qName, index);
    }

    @Override
    public NodePointer createChild(JXPathContext context, QName qName, int index, Object value) {
        return this.createPath(context).createChild(context, qName, index, value);
    }

    @Override
    public NodePointer createPath(JXPathContext context) {
        NodePointer newParent = this.parent.createPath(context);
        if (this.isAttribute()) {
            return newParent.createAttribute(context, this.getName());
        }
        if (this.parent instanceof NullPointer && this.parent.equals(newParent)) {
            throw this.createBadFactoryException(context.getFactory());
        }
        if (newParent instanceof PropertyOwnerPointer) {
            PropertyOwnerPointer pop = (PropertyOwnerPointer)newParent;
            newParent = pop.getPropertyPointer();
        }
        return newParent.createChild(context, this.getName(), this.getIndex());
    }

    @Override
    public NodePointer createPath(JXPathContext context, Object value) {
        NodePointer newParent = this.parent.createPath(context);
        if (this.isAttribute()) {
            NodePointer pointer = newParent.createAttribute(context, this.getName());
            pointer.setValue(value);
            return pointer;
        }
        if (this.parent instanceof NullPointer && this.parent.equals(newParent)) {
            throw this.createBadFactoryException(context.getFactory());
        }
        if (newParent instanceof PropertyOwnerPointer) {
            PropertyOwnerPointer pop = (PropertyOwnerPointer)newParent;
            newParent = pop.getPropertyPointer();
        }
        return newParent.createChild(context, this.getName(), this.index, value);
    }

    @Override
    public Object getBaseValue() {
        return null;
    }

    @Override
    public Object getImmediateNode() {
        return null;
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public QName getName() {
        return new QName(this.propertyName);
    }

    @Override
    public int getPropertyCount() {
        return 0;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String[] getPropertyNames() {
        return new String[0];
    }

    @Override
    public NodePointer getValuePointer() {
        return new NullPointer((NodePointer)this, new QName(this.getPropertyName()));
    }

    @Override
    public boolean isActual() {
        return false;
    }

    @Override
    protected boolean isActualProperty() {
        return false;
    }

    @Override
    public boolean isCollection() {
        return this.getIndex() != Integer.MIN_VALUE;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public void setNameAttributeValue(String attributeValue) {
        this.propertyName = attributeValue;
        this.byNameAttribute = true;
    }

    @Override
    public void setPropertyIndex(int index) {
    }

    @Override
    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public void setValue(Object value) {
        if (this.parent == null || this.parent.isContainer()) {
            throw new JXPathInvalidAccessException("Cannot set property " + this.asPath() + ", the target object is null");
        }
        if (!(this.parent instanceof PropertyOwnerPointer) || !((PropertyOwnerPointer)this.parent).isDynamicPropertyDeclarationSupported()) {
            throw new JXPathInvalidAccessException("Cannot set property " + this.asPath() + ", path does not match a changeable location");
        }
        PropertyPointer propertyPointer = ((PropertyOwnerPointer)this.parent).getPropertyPointer();
        propertyPointer.setPropertyName(this.propertyName);
        propertyPointer.setValue(value);
    }
}

