/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.roundtrip;

import java.awt.image.BufferedImage;
import java.util.stream.Stream;
import org.apache.commons.imaging.roundtrip.FormatInfo;
import org.apache.commons.imaging.roundtrip.RoundtripBase;
import org.apache.commons.imaging.roundtrip.TestImages;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class LimitedColorRoundtripTest
extends RoundtripBase {
    public static BufferedImage[] images = new BufferedImage[]{TestImages.createLimitedColorImage(1, 1), TestImages.createLimitedColorImage(2, 2), TestImages.createLimitedColorImage(10, 10), TestImages.createLimitedColorImage(300, 300)};

    public static Stream<Arguments> testLimitedColorRoundtrip() {
        return LimitedColorRoundtripTest.createRoundtripArguments(images);
    }

    @ParameterizedTest
    @MethodSource
    public void testLimitedColorRoundtrip(BufferedImage testImage, FormatInfo formatInfo) throws Exception {
        boolean imageExact = true;
        if (formatInfo.colorSupport == 3) {
            imageExact = false;
        }
        if (formatInfo.colorSupport == 2) {
            imageExact = false;
        }
        this.roundtrip(formatInfo, testImage, "indexable", imageExact);
    }
}

