/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.apache.commons.imaging.FormatCompliance;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.ImagingTestConstants;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.formats.tiff.AbstractTiffRasterData;
import org.apache.commons.imaging.formats.tiff.TiffContents;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.apache.commons.imaging.formats.tiff.TiffReader;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.AbstractPhotometricInterpreter;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.floatingpoint.PaletteEntryForRange;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.floatingpoint.PaletteEntryForValue;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.floatingpoint.PhotometricInterpreterFloat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TiffFloatingPointReadTest {
    private void checkSubImage(File target, AbstractTiffRasterData fullRaster, int x0, int y0, int width, int height) throws ImagingException, IOException {
        TiffImagingParameters params = new TiffImagingParameters();
        params.setSubImage(x0, y0, width, height);
        AbstractTiffRasterData partRaster = this.readRasterFromTIFF(target, params);
        Assertions.assertEquals((int)width, (int)partRaster.getWidth(), (String)("Invalid width in partial for " + target.getName()));
        Assertions.assertEquals((int)height, (int)partRaster.getHeight(), (String)("Invalid height in partial for " + target.getName()));
        for (int y = y0; y < y0 + height; ++y) {
            for (int x = x0; x < x0 + width; ++x) {
                float vFull = fullRaster.getValue(x, y);
                float vPart = partRaster.getValue(x - x0, y - y0);
                Assertions.assertEquals((float)vFull, (float)vPart, (String)("Invalid value match for partial at (" + x + "," + y + ") for " + target.getName()));
            }
        }
    }

    private File getTiffFile(String name) {
        File tiffFolder = new File(ImagingTestConstants.TEST_IMAGE_FOLDER, "tiff");
        File fpFolder = new File(tiffFolder, "9");
        return new File(fpFolder, name);
    }

    private PhotometricInterpreterFloat readAndInterpretTIFF(File target, float f0, float f1, float fNot) throws ImagingException, IOException {
        ByteSource byteSource = ByteSource.file((File)target);
        TiffReader tiffReader = new TiffReader(true);
        TiffContents contents = tiffReader.readDirectories(byteSource, true, FormatCompliance.getDefault());
        ByteOrder byteOrder = tiffReader.getByteOrder();
        TiffDirectory directory = (TiffDirectory)contents.directories.get(0);
        if (!directory.hasTiffFloatingPointRasterData()) {
            Assertions.fail((String)("Internal error, sample file does not have floating-point data " + target.getName()));
        }
        ArrayList<Object> pList = new ArrayList<Object>();
        pList.add(new PaletteEntryForValue(fNot, Color.red));
        pList.add(new PaletteEntryForRange(f0, f1, Color.black, Color.white));
        PhotometricInterpreterFloat pInterp = new PhotometricInterpreterFloat(pList);
        TiffImagingParameters params = new TiffImagingParameters();
        params.setCustomPhotometricInterpreter((AbstractPhotometricInterpreter)pInterp);
        BufferedImage bImage = directory.getTiffImage(byteOrder, params);
        if (bImage == null) {
            return null;
        }
        return pInterp;
    }

    private AbstractTiffRasterData readRasterFromTIFF(File target, TiffImagingParameters params) throws ImagingException, IOException {
        ByteSource byteSource = ByteSource.file((File)target);
        TiffReader tiffReader = new TiffReader(true);
        TiffContents contents = tiffReader.readDirectories(byteSource, true, FormatCompliance.getDefault());
        TiffDirectory directory = (TiffDirectory)contents.directories.get(0);
        return directory.getRasterData(params);
    }

    @Test
    public void test() throws ImagingException, IOException {
        int i;
        File target = this.getTiffFile("Sample64BitFloatingPointPix451x337.tiff");
        PhotometricInterpreterFloat pInterp = this.readAndInterpretTIFF(target, 0.0f, 1.0f, 9999.0f);
        if (pInterp == null) {
            Assertions.fail((String)("Failed to read image " + target.getAbsolutePath()));
        }
        float minVal = pInterp.getMinFound();
        float maxVal = pInterp.getMaxFound();
        boolean testCondition = 0.0 <= (double)minVal && (double)minVal <= 1.0 && 0.0 <= (double)maxVal && (double)maxVal <= 1.0;
        Assertions.assertTrue((boolean)testCondition, (String)("Min,Max values not in range 0 to 1: " + minVal + ", " + maxVal));
        Assertions.assertTrue((minVal <= maxVal ? 1 : 0) != 0, (String)("Min Value not <= maxVal: " + minVal + ", " + maxVal));
        AbstractTiffRasterData fullRaster = this.readRasterFromTIFF(target, new TiffImagingParameters());
        int height = fullRaster.getHeight();
        int width = fullRaster.getWidth();
        this.checkSubImage(target, fullRaster, 17, 17, 200, 200);
        this.checkSubImage(target, fullRaster, 1, 3, width - 2, 1);
        this.checkSubImage(target, fullRaster, 1, 3, width - 2, 3);
        this.checkSubImage(target, fullRaster, 1, 4, width - 2, 1);
        this.checkSubImage(target, fullRaster, 1, 4, width - 2, 3);
        this.checkSubImage(target, fullRaster, 0, 0, width, 1);
        this.checkSubImage(target, fullRaster, 0, 0, 1, height);
        this.checkSubImage(target, fullRaster, 0, height - 1, width, 1);
        this.checkSubImage(target, fullRaster, width - 1, 0, 1, height);
        int s = width - height;
        for (i = 0; i < height - 8; ++i) {
            this.checkSubImage(target, fullRaster, i, i, 8, 8);
            this.checkSubImage(target, fullRaster, i + 1, i, 8, 8);
        }
        this.checkSubImage(target, fullRaster, 0, 0, width, height);
        target = this.getTiffFile("USGS_13_n38w077_dir5.tiff");
        pInterp = this.readAndInterpretTIFF(target, -2.0f, 62.0f, -99999.0f);
        if (pInterp == null) {
            Assertions.fail((String)("Failed to read image " + target.getAbsolutePath()));
        }
        minVal = pInterp.getMinFound();
        maxVal = pInterp.getMaxFound();
        testCondition = -2.0f <= minVal && minVal <= 62.0f && -2.0f <= maxVal && maxVal <= 62.0f;
        Assertions.assertTrue((boolean)testCondition, (String)("Min,Max values not in range -2 to 62: " + minVal + ", " + maxVal));
        Assertions.assertTrue((minVal <= maxVal ? 1 : 0) != 0, (String)("Min Value not <= maxVal: " + minVal + ", " + maxVal));
        fullRaster = this.readRasterFromTIFF(target, new TiffImagingParameters());
        height = fullRaster.getHeight();
        width = fullRaster.getWidth();
        this.checkSubImage(target, fullRaster, 126, 126, 132, 132);
        this.checkSubImage(target, fullRaster, 128, 128, 128, 128);
        this.checkSubImage(target, fullRaster, 1, 1, width - 2, height - 2);
        this.checkSubImage(target, fullRaster, 0, 0, width, 1);
        this.checkSubImage(target, fullRaster, 0, 0, 1, height);
        this.checkSubImage(target, fullRaster, 0, height - 1, width, 1);
        this.checkSubImage(target, fullRaster, width - 1, 0, 1, height);
        for (i = 0; i < height - 8; ++i) {
            this.checkSubImage(target, fullRaster, i, i, 8, 8);
        }
        this.checkSubImage(target, fullRaster, 0, 0, width, height);
    }
}

