/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.ObjectGraphIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ObjectGraphIteratorTest
extends AbstractIteratorTest<Object> {
    protected String[] testArray = new String[]{"One", "Two", "Three", "Four", "Five", "Six"};
    protected List<String> list1;
    protected List<String> list2;
    protected List<String> list3;
    protected List<Iterator<String>> iteratorList;

    @Override
    public ObjectGraphIterator<Object> makeEmptyIterator() {
        ArrayList list = new ArrayList();
        return new ObjectGraphIterator(list.iterator());
    }

    @Override
    public ObjectGraphIterator<Object> makeObject() {
        this.setUp();
        return new ObjectGraphIterator(this.iteratorList.iterator());
    }

    @BeforeEach
    public void setUp() {
        this.list1 = new ArrayList<String>();
        this.list1.add("One");
        this.list1.add("Two");
        this.list1.add("Three");
        this.list2 = new ArrayList<String>();
        this.list2.add("Four");
        this.list3 = new ArrayList<String>();
        this.list3.add("Five");
        this.list3.add("Six");
        this.iteratorList = new ArrayList<Iterator<String>>();
        this.iteratorList.add(this.list1.iterator());
        this.iteratorList.add(this.list2.iterator());
        this.iteratorList.add(this.list3.iterator());
    }

    @Test
    public void testIteration_IteratorOfIterators() {
        ArrayList<Iterator<String>> iteratorList = new ArrayList<Iterator<String>>();
        iteratorList.add(this.list1.iterator());
        iteratorList.add(this.list2.iterator());
        iteratorList.add(this.list3.iterator());
        ObjectGraphIterator it = new ObjectGraphIterator(iteratorList.iterator(), null);
        for (int i = 0; i < 6; ++i) {
            Assertions.assertTrue((boolean)it.hasNext());
            Assertions.assertEquals((Object)this.testArray[i], it.next());
        }
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testIteration_IteratorOfIteratorsWithEmptyIterators() {
        ArrayList<Object> iteratorList = new ArrayList<Object>();
        iteratorList.add(IteratorUtils.emptyIterator());
        iteratorList.add(this.list1.iterator());
        iteratorList.add(IteratorUtils.emptyIterator());
        iteratorList.add(this.list2.iterator());
        iteratorList.add(IteratorUtils.emptyIterator());
        iteratorList.add(this.list3.iterator());
        iteratorList.add(IteratorUtils.emptyIterator());
        ObjectGraphIterator it = new ObjectGraphIterator(iteratorList.iterator(), null);
        for (int i = 0; i < 6; ++i) {
            Assertions.assertTrue((boolean)it.hasNext());
            Assertions.assertEquals((Object)this.testArray[i], it.next());
        }
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testIteration_RootNoTransformer() {
        Forest forest = new Forest();
        ObjectGraphIterator it = new ObjectGraphIterator((Object)forest, null);
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertSame((Object)forest, it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> ObjectGraphIteratorTest.lambda$testIteration_RootNoTransformer$0((Iterator)it));
    }

    @Test
    public void testIteration_RootNull() {
        ObjectGraphIterator it = new ObjectGraphIterator(null, null);
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> ObjectGraphIteratorTest.lambda$testIteration_RootNull$1((Iterator)it));
        Assertions.assertThrows(IllegalStateException.class, () -> ObjectGraphIteratorTest.lambda$testIteration_RootNull$2((Iterator)it));
    }

    @Test
    public void testIteration_Transformed1() {
        Forest forest = new Forest();
        Leaf l1 = forest.addTree().addBranch().addLeaf();
        ObjectGraphIterator it = new ObjectGraphIterator((Object)forest, (Transformer)new LeafFinder());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertSame((Object)l1, it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> ObjectGraphIteratorTest.lambda$testIteration_Transformed1$3((Iterator)it));
    }

    @Test
    public void testIteration_Transformed2() {
        Forest forest = new Forest();
        forest.addTree();
        forest.addTree();
        forest.addTree();
        Branch b1 = forest.getTree(0).addBranch();
        Branch b2 = forest.getTree(0).addBranch();
        Branch b3 = forest.getTree(2).addBranch();
        forest.getTree(2).addBranch();
        Branch b5 = forest.getTree(2).addBranch();
        Leaf l1 = b1.addLeaf();
        Leaf l2 = b1.addLeaf();
        Leaf l3 = b2.addLeaf();
        Leaf l4 = b3.addLeaf();
        Leaf l5 = b5.addLeaf();
        ObjectGraphIterator it = new ObjectGraphIterator((Object)forest, (Transformer)new LeafFinder());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertSame((Object)l1, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertSame((Object)l2, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertSame((Object)l3, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertSame((Object)l4, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertSame((Object)l5, it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> ObjectGraphIteratorTest.lambda$testIteration_Transformed2$4((Iterator)it));
    }

    @Test
    public void testIteration_Transformed3() {
        Forest forest = new Forest();
        forest.addTree();
        forest.addTree();
        forest.addTree();
        Branch b1 = forest.getTree(1).addBranch();
        Branch b2 = forest.getTree(1).addBranch();
        Branch b3 = forest.getTree(2).addBranch();
        Branch b4 = forest.getTree(2).addBranch();
        forest.getTree(2).addBranch();
        Leaf l1 = b1.addLeaf();
        Leaf l2 = b1.addLeaf();
        Leaf l3 = b2.addLeaf();
        Leaf l4 = b3.addLeaf();
        Leaf l5 = b4.addLeaf();
        ObjectGraphIterator it = new ObjectGraphIterator((Object)forest, (Transformer)new LeafFinder());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertSame((Object)l1, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertSame((Object)l2, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertSame((Object)l3, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertSame((Object)l4, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertSame((Object)l5, it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> ObjectGraphIteratorTest.lambda$testIteration_Transformed3$5((Iterator)it));
    }

    @Test
    public void testIteratorConstructor_null_next() {
        ObjectGraphIterator it = new ObjectGraphIterator(null);
        Assertions.assertThrows(NoSuchElementException.class, () -> ObjectGraphIteratorTest.lambda$testIteratorConstructor_null_next$6((Iterator)it));
    }

    @Test
    public void testIteratorConstructor_null_remove() {
        ObjectGraphIterator it = new ObjectGraphIterator(null);
        Assertions.assertThrows(IllegalStateException.class, () -> ObjectGraphIteratorTest.lambda$testIteratorConstructor_null_remove$7((Iterator)it));
    }

    @Test
    public void testIteratorConstructor_null1() {
        ObjectGraphIterator it = new ObjectGraphIterator(null);
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> ObjectGraphIteratorTest.lambda$testIteratorConstructor_null1$8((Iterator)it));
        Assertions.assertThrows(IllegalStateException.class, () -> ObjectGraphIteratorTest.lambda$testIteratorConstructor_null1$9((Iterator)it));
    }

    @Test
    public void testIteratorConstructorIteration_Empty() {
        ArrayList iteratorList = new ArrayList();
        ObjectGraphIterator it = new ObjectGraphIterator(iteratorList.iterator());
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> ObjectGraphIteratorTest.lambda$testIteratorConstructorIteration_Empty$10((Iterator)it));
        Assertions.assertThrows(IllegalStateException.class, () -> ObjectGraphIteratorTest.lambda$testIteratorConstructorIteration_Empty$11((Iterator)it));
    }

    @Test
    public void testIteratorConstructorIteration_Simple() {
        ArrayList<Iterator<String>> iteratorList = new ArrayList<Iterator<String>>();
        iteratorList.add(this.list1.iterator());
        iteratorList.add(this.list2.iterator());
        iteratorList.add(this.list3.iterator());
        ObjectGraphIterator it = new ObjectGraphIterator(iteratorList.iterator());
        for (int i = 0; i < 6; ++i) {
            Assertions.assertTrue((boolean)it.hasNext());
            Assertions.assertEquals((Object)this.testArray[i], it.next());
        }
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> ObjectGraphIteratorTest.lambda$testIteratorConstructorIteration_Simple$12((Iterator)it));
    }

    @Test
    public void testIteratorConstructorIteration_SimpleNoHasNext() {
        ArrayList<Iterator<String>> iteratorList = new ArrayList<Iterator<String>>();
        iteratorList.add(this.list1.iterator());
        iteratorList.add(this.list2.iterator());
        iteratorList.add(this.list3.iterator());
        ObjectGraphIterator it = new ObjectGraphIterator(iteratorList.iterator());
        for (int i = 0; i < 6; ++i) {
            Assertions.assertEquals((Object)this.testArray[i], it.next());
        }
        Assertions.assertThrows(NoSuchElementException.class, () -> ObjectGraphIteratorTest.lambda$testIteratorConstructorIteration_SimpleNoHasNext$13((Iterator)it));
    }

    @Test
    public void testIteratorConstructorIteration_WithEmptyIterators() {
        ArrayList<Object> iteratorList = new ArrayList<Object>();
        iteratorList.add(IteratorUtils.emptyIterator());
        iteratorList.add(this.list1.iterator());
        iteratorList.add(IteratorUtils.emptyIterator());
        iteratorList.add(this.list2.iterator());
        iteratorList.add(IteratorUtils.emptyIterator());
        iteratorList.add(this.list3.iterator());
        iteratorList.add(IteratorUtils.emptyIterator());
        ObjectGraphIterator it = new ObjectGraphIterator(iteratorList.iterator());
        for (int i = 0; i < 6; ++i) {
            Assertions.assertTrue((boolean)it.hasNext());
            Assertions.assertEquals((Object)this.testArray[i], it.next());
        }
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> ObjectGraphIteratorTest.lambda$testIteratorConstructorIteration_WithEmptyIterators$14((Iterator)it));
    }

    @Test
    public void testIteratorConstructorRemove() {
        ArrayList<Iterator<String>> iteratorList = new ArrayList<Iterator<String>>();
        iteratorList.add(this.list1.iterator());
        iteratorList.add(this.list2.iterator());
        iteratorList.add(this.list3.iterator());
        ObjectGraphIterator it = new ObjectGraphIterator(iteratorList.iterator());
        for (int i = 0; i < 6; ++i) {
            Assertions.assertEquals((Object)this.testArray[i], it.next());
            it.remove();
        }
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertEquals((int)0, (int)this.list1.size());
        Assertions.assertEquals((int)0, (int)this.list2.size());
        Assertions.assertEquals((int)0, (int)this.list3.size());
    }

    private static /* synthetic */ void lambda$testIteratorConstructorIteration_WithEmptyIterators$14(Iterator it) throws Throwable {
        it.next();
    }

    private static /* synthetic */ void lambda$testIteratorConstructorIteration_SimpleNoHasNext$13(Iterator it) throws Throwable {
        it.next();
    }

    private static /* synthetic */ void lambda$testIteratorConstructorIteration_Simple$12(Iterator it) throws Throwable {
        it.next();
    }

    private static /* synthetic */ void lambda$testIteratorConstructorIteration_Empty$11(Iterator it) throws Throwable {
        it.remove();
    }

    private static /* synthetic */ void lambda$testIteratorConstructorIteration_Empty$10(Iterator it) throws Throwable {
        it.next();
    }

    private static /* synthetic */ void lambda$testIteratorConstructor_null1$9(Iterator it) throws Throwable {
        it.remove();
    }

    private static /* synthetic */ void lambda$testIteratorConstructor_null1$8(Iterator it) throws Throwable {
        it.next();
    }

    private static /* synthetic */ void lambda$testIteratorConstructor_null_remove$7(Iterator it) throws Throwable {
        it.remove();
    }

    private static /* synthetic */ void lambda$testIteratorConstructor_null_next$6(Iterator it) throws Throwable {
        it.next();
    }

    private static /* synthetic */ void lambda$testIteration_Transformed3$5(Iterator it) throws Throwable {
        it.next();
    }

    private static /* synthetic */ void lambda$testIteration_Transformed2$4(Iterator it) throws Throwable {
        it.next();
    }

    private static /* synthetic */ void lambda$testIteration_Transformed1$3(Iterator it) throws Throwable {
        it.next();
    }

    private static /* synthetic */ void lambda$testIteration_RootNull$2(Iterator it) throws Throwable {
        it.remove();
    }

    private static /* synthetic */ void lambda$testIteration_RootNull$1(Iterator it) throws Throwable {
        it.next();
    }

    private static /* synthetic */ void lambda$testIteration_RootNoTransformer$0(Iterator it) throws Throwable {
        it.next();
    }

    static class Forest {
        List<Tree> trees = new ArrayList<Tree>();

        Forest() {
        }

        Tree addTree() {
            this.trees.add(new Tree());
            return this.getTree(this.trees.size() - 1);
        }

        Tree getTree(int index) {
            return this.trees.get(index);
        }

        Iterator<Tree> treeIterator() {
            return this.trees.iterator();
        }
    }

    static class Tree {
        List<Branch> branches = new ArrayList<Branch>();

        Tree() {
        }

        Branch addBranch() {
            this.branches.add(new Branch());
            return this.getBranch(this.branches.size() - 1);
        }

        Iterator<Branch> branchIterator() {
            return this.branches.iterator();
        }

        Branch getBranch(int index) {
            return this.branches.get(index);
        }
    }

    static class Branch {
        List<Leaf> leaves = new ArrayList<Leaf>();

        Branch() {
        }

        Leaf addLeaf() {
            this.leaves.add(new Leaf());
            return this.getLeaf(this.leaves.size() - 1);
        }

        Leaf getLeaf(int index) {
            return this.leaves.get(index);
        }

        Iterator<Leaf> leafIterator() {
            return this.leaves.iterator();
        }
    }

    static class Leaf {
        String color;

        Leaf() {
        }

        String getColor() {
            return this.color;
        }

        void setColor(String color) {
            this.color = color;
        }
    }

    static class LeafFinder
    implements Transformer<Object, Object> {
        LeafFinder() {
        }

        public Object transform(Object input) {
            if (input instanceof Forest) {
                return ((Forest)input).treeIterator();
            }
            if (input instanceof Tree) {
                return ((Tree)input).branchIterator();
            }
            if (input instanceof Branch) {
                return ((Branch)input).leafIterator();
            }
            if (input instanceof Leaf) {
                return input;
            }
            throw new ClassCastException();
        }
    }
}

