/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.converters.DateTimeConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractDateConverterTest<T> {
    protected abstract Class<T> getExpectedType();

    protected long getTimeInMillis(Object date) {
        if (date instanceof Date) {
            return ((Date)date).getTime();
        }
        if (date instanceof Timestamp) {
            return ((Timestamp)date).getTime();
        }
        if (date instanceof LocalDate) {
            return ((LocalDate)date).atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
        }
        if (date instanceof LocalDateTime) {
            return ((LocalDateTime)date).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        }
        if (date instanceof ZonedDateTime) {
            return ((ZonedDateTime)date).toInstant().toEpochMilli();
        }
        if (date instanceof OffsetDateTime) {
            return ((OffsetDateTime)date).toInstant().toEpochMilli();
        }
        if (date instanceof Calendar) {
            return ((Calendar)date).getTime().getTime();
        }
        if (date instanceof java.util.Date) {
            return ((java.util.Date)date).getTime();
        }
        throw new IllegalArgumentException(Objects.toString(date));
    }

    protected void invalidConversion(Converter<T> converter, Object value) {
        String valueType = value == null ? "null" : value.getClass().getName();
        String msg = "Converting '" + valueType + "' value '" + value + "'";
        try {
            Object result = converter.convert(this.getExpectedType(), value);
            Assertions.fail((String)(msg + ", expected ConversionException, but result = '" + result + "'"));
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    protected abstract DateTimeConverter<T> makeConverter();

    protected abstract DateTimeConverter<T> makeConverter(T var1);

    protected void stringConversion(Converter<T> converter, String expected, Object value) {
        String valueType = value == null ? "null" : value.getClass().getName();
        String msg = "Converting '" + valueType + "' value '" + value + "' to String";
        try {
            String result = (String)converter.convert(String.class, value);
            Class<?> resultType = result == null ? null : result.getClass();
            Class<?> expectType = expected == null ? null : expected.getClass();
            Assertions.assertEquals(expectType, resultType, () -> "TYPE " + msg);
            Assertions.assertEquals((Object)expected, (Object)result, () -> "VALUE " + msg);
        }
        catch (Exception ex) {
            throw new IllegalStateException(msg + " threw " + ex.toString(), ex);
        }
    }

    @Test
    public void testConvertDate() {
        String[] message = new String[]{"from Date", "from Calendar", "from SQL Date", "from SQL Time", "from SQL Timestamp", "from LocalDate", "from LocalDateTime", "from ZonedDateTime", "from OffsetDateTime"};
        long nowMillis = System.currentTimeMillis();
        Object[] date = new Object[]{new java.util.Date(nowMillis), new GregorianCalendar(), new Date(nowMillis), new Time(nowMillis), new Timestamp(nowMillis), Instant.ofEpochMilli(nowMillis).atZone(ZoneId.systemDefault()).toLocalDate().atStartOfDay(ZoneId.systemDefault()).toLocalDate(), Instant.ofEpochMilli(nowMillis).atZone(ZoneId.systemDefault()).toLocalDateTime(), ZonedDateTime.ofInstant(Instant.ofEpochMilli(nowMillis), ZoneId.systemDefault()), OffsetDateTime.ofInstant(Instant.ofEpochMilli(nowMillis), ZoneId.systemDefault())};
        ((GregorianCalendar)date[1]).setTime(new java.util.Date(nowMillis));
        for (int i = 0; i < date.length; ++i) {
            Class<T> expectedType = this.getExpectedType();
            Object val = this.makeConverter().convert(expectedType, date[i]);
            Assertions.assertNotNull((Object)val, (String)("Convert " + message[i] + " should not be null"));
            Assertions.assertInstanceOf(expectedType, (Object)val, (String)("Convert " + message[i] + " should return a " + expectedType.getName()));
            long test = nowMillis;
            if (date[i] instanceof LocalDate || val instanceof LocalDate) {
                test = Instant.ofEpochMilli(nowMillis).atZone(ZoneId.systemDefault()).toLocalDate().atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
            }
            Assertions.assertEquals((long)test, (long)this.getTimeInMillis(val), (String)("Convert " + message[i] + " should return a " + date[0]));
        }
    }

    @Test
    public void testConvertNull() {
        Assertions.assertThrows(ConversionException.class, () -> this.makeConverter().convert(this.getExpectedType(), null), (String)"Expected ConversionException");
    }

    @Test
    public void testDefaultStringToTypeConvert() {
        DateTimeConverter<T> converter = this.makeConverter();
        converter.setUseLocaleFormat(false);
        Assertions.assertThrows(ConversionException.class, () -> converter.convert(this.getExpectedType(), (Object)"2006-10-23"), (String)"Expected Conversion exception");
    }

    @Test
    public void testDefaultType() {
        String pattern = "yyyy-MM-dd";
        DateTimeConverter<T> converter = this.makeConverter();
        converter.setPattern("yyyy-MM-dd");
        String testString = "2006-10-29";
        Calendar calendar = this.toCalendar("2006-10-29", "yyyy-MM-dd", null);
        T expected = this.toType(calendar);
        Object result = converter.convert(null, (Object)"2006-10-29");
        Class<T> expectedType = this.getExpectedType();
        if (expectedType.equals(Calendar.class)) {
            Assertions.assertTrue((boolean)expectedType.isAssignableFrom(result.getClass()), (String)"TYPE ");
        } else {
            Assertions.assertInstanceOf(expectedType, (Object)result, (String)"TYPE ");
        }
        Assertions.assertEquals(expected, (Object)result, (String)"VALUE ");
    }

    @Test
    public void testInvalidType() {
        DateTimeConverter converter = this.makeConverter();
        Assertions.assertThrows(ConversionException.class, () -> converter.convert(Character.class, (Object)new java.util.Date()), (String)"Requested Character.class conversion, expected ConversionException");
    }

    @Test
    public void testLocale() {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        String pattern = "M/d/yy";
        DateTimeConverter<T> converter = this.makeConverter();
        converter.setUseLocaleFormat(true);
        String testString = "10/28/06";
        T expected = this.toType("10/28/06", "M/d/yy", null);
        this.validConversion((Converter<T>)converter, expected, "10/28/06");
        this.invalidConversion((Converter<T>)converter, null);
        this.invalidConversion((Converter<T>)converter, "");
        this.invalidConversion((Converter<T>)converter, "2006-10-2X");
        this.invalidConversion((Converter<T>)converter, "10.28.06");
        this.invalidConversion((Converter<T>)converter, "10-28-06");
        this.invalidConversion((Converter<T>)converter, 2);
        Locale.setDefault(defaultLocale);
    }

    @Test
    public void testMultiplePatterns() {
        String[] patterns = new String[]{"yyyy-MM-dd", "yyyy/MM/dd"};
        DateTimeConverter<T> converter = this.makeConverter();
        converter.setPatterns(patterns);
        String testString = "2006-10-28";
        T expected = this.toType(testString, patterns[0], null);
        this.validConversion((Converter<T>)converter, expected, testString);
        testString = "2006/10/18";
        expected = this.toType(testString, patterns[1], null);
        this.validConversion((Converter<T>)converter, expected, testString);
        this.invalidConversion((Converter<T>)converter, "17/03/2006");
        this.invalidConversion((Converter<T>)converter, "17.03.2006");
    }

    @Test
    public void testPatternDefault() {
        String pattern = "yyyy-MM-dd";
        T defaultValue = this.toType("2000-01-01", "yyyy-MM-dd", null);
        Assertions.assertNotNull(defaultValue, (String)"Check default date");
        DateTimeConverter<T> converter = this.makeConverter(defaultValue);
        converter.setPattern("yyyy-MM-dd");
        String testString = "2006-10-29";
        T expected = this.toType("2006-10-29", "yyyy-MM-dd", null);
        this.validConversion((Converter<T>)converter, expected, "2006-10-29");
        this.validConversion((Converter<T>)converter, defaultValue, null);
        this.validConversion((Converter<T>)converter, defaultValue, "");
        this.validConversion((Converter<T>)converter, defaultValue, "2006-10-2X");
        this.validConversion((Converter<T>)converter, defaultValue, "2006/10/01");
        this.validConversion((Converter<T>)converter, defaultValue, "02/10/06");
        this.validConversion((Converter<T>)converter, defaultValue, 2);
    }

    @Test
    public void testPatternNoDefault() {
        String pattern = "yyyy-MM-dd";
        DateTimeConverter<T> converter = this.makeConverter();
        converter.setPattern("yyyy-MM-dd");
        String testString = "2006-10-29";
        Calendar calendar = this.toCalendar("2006-10-29", "yyyy-MM-dd", null);
        T expected = this.toType(calendar);
        this.validConversion((Converter<T>)converter, expected, "2006-10-29");
        this.validConversion((Converter<T>)converter, expected, calendar);
        this.validConversion((Converter<T>)converter, expected, this.toDate(calendar));
        this.validConversion((Converter<T>)converter, expected, this.toSqlDate(calendar));
        this.validConversion((Converter<T>)converter, expected, this.toSqlTimestamp(calendar));
        this.validConversion((Converter<T>)converter, expected, this.toSqlTime(calendar));
        this.invalidConversion((Converter<T>)converter, null);
        this.invalidConversion((Converter<T>)converter, "");
        this.invalidConversion((Converter<T>)converter, "2006-10-2X");
        this.invalidConversion((Converter<T>)converter, "2006/10/01");
        this.invalidConversion((Converter<T>)converter, "02/10/2006");
        this.invalidConversion((Converter<T>)converter, "02/10/06");
        this.invalidConversion((Converter<T>)converter, 2);
    }

    @Test
    public void testPatternNullDefault() {
        String pattern = "yyyy-MM-dd";
        T defaultValue = null;
        DateTimeConverter<Object> converter = this.makeConverter(defaultValue);
        converter.setPattern("yyyy-MM-dd");
        String testString = "2006-10-29";
        T expected = this.toType("2006-10-29", "yyyy-MM-dd", null);
        this.validConversion((Converter<T>)converter, expected, "2006-10-29");
        this.validConversion((Converter<T>)converter, defaultValue, null);
        this.validConversion((Converter<T>)converter, defaultValue, "");
        this.validConversion((Converter<T>)converter, defaultValue, "2006-10-2X");
        this.validConversion((Converter<T>)converter, defaultValue, "2006/10/01");
        this.validConversion((Converter<T>)converter, defaultValue, "02/10/06");
        this.validConversion((Converter<T>)converter, defaultValue, 2);
    }

    @Test
    public void testStringConversion() {
        String pattern = "yyyy-MM-dd";
        DateTimeConverter<T> converter = this.makeConverter();
        converter.setPattern("yyyy-MM-dd");
        String expected = "2006-10-29";
        Calendar calendar = this.toCalendar("2006-10-29", "yyyy-MM-dd", null);
        this.stringConversion((Converter<T>)converter, "2006-10-29", this.toType(calendar));
        this.stringConversion((Converter<T>)converter, "2006-10-29", calendar);
        this.stringConversion((Converter<T>)converter, "2006-10-29", this.toDate(calendar));
        this.stringConversion((Converter<T>)converter, "2006-10-29", this.toSqlDate(calendar));
        this.stringConversion((Converter<T>)converter, "2006-10-29", this.toSqlTimestamp(calendar));
        this.stringConversion((Converter<T>)converter, "2006-10-29", this.toSqlTime(calendar));
        this.stringConversion((Converter<T>)converter, "2006-10-29", this.toLocalDateTime(calendar));
        this.stringConversion((Converter<T>)converter, null, null);
        this.stringConversion((Converter<T>)converter, "", "");
    }

    Calendar toCalendar(String value, String pattern, Locale locale) {
        Calendar calendar = null;
        try {
            SimpleDateFormat format = locale == null ? new SimpleDateFormat(pattern) : new SimpleDateFormat(pattern, locale);
            format.setLenient(false);
            format.parse(value);
            calendar = format.getCalendar();
        }
        catch (Exception e) {
            Assertions.fail((String)("Error creating Calendar value ='" + value + ", pattern='" + pattern + "' " + e.toString()));
        }
        return calendar;
    }

    java.util.Date toDate(Calendar calendar) {
        return calendar.getTime();
    }

    LocalDateTime toLocalDateTime(Calendar calendar) {
        return Instant.ofEpochMilli(calendar.getTimeInMillis()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    Date toSqlDate(Calendar calendar) {
        return new Date(this.getTimeInMillis(calendar));
    }

    Time toSqlTime(Calendar calendar) {
        return new Time(this.getTimeInMillis(calendar));
    }

    Timestamp toSqlTimestamp(Calendar calendar) {
        return new Timestamp(this.getTimeInMillis(calendar));
    }

    protected abstract T toType(Calendar var1);

    protected T toType(String value, String pattern, Locale locale) {
        return this.toType(this.toCalendar(value, pattern, locale));
    }

    protected void validConversion(Converter<T> converter, Object expected, Object value) {
        String valueType = value == null ? "null" : value.getClass().getName();
        String msg = "Converting '" + valueType + "' value '" + value + "'";
        Object result = Assertions.assertDoesNotThrow(() -> converter.convert(this.getExpectedType(), value));
        Class<?> resultType = result == null ? null : result.getClass();
        Class<?> expectType = expected == null ? null : expected.getClass();
        Assertions.assertEquals(expectType, resultType, () -> "TYPE " + msg);
        Assertions.assertEquals((Object)expected, (Object)result, () -> "VALUE " + msg);
    }
}

