/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.modules;

import org.apache.cassandra.sidecar.common.server.CQLSessionProvider;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.coordination.ElectorateMembership;
import org.apache.cassandra.sidecar.coordination.MostReplicatedKeyspaceTokenZeroElectorateMembership;
import org.apache.cassandra.sidecar.coordination.SidecarInternalTokenZeroElectorateMembership;
import org.apache.cassandra.sidecar.exceptions.ConfigurationException;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;

public class ElectorateMembershipFactory {
    public ElectorateMembership create(InstanceMetadataFetcher fetcher, CQLSessionProvider sessionProvider, SidecarConfiguration config) {
        String strategy;
        switch (strategy = config.serviceConfiguration().coordinationConfiguration().clusterLeaseClaimConfiguration().electorateMembershipStrategy()) {
            case "MostReplicatedKeyspaceTokenZeroElectorateMembership": {
                return new MostReplicatedKeyspaceTokenZeroElectorateMembership(fetcher, sessionProvider, config);
            }
            case "SidecarInternalTokenZeroElectorateMembership": {
                return new SidecarInternalTokenZeroElectorateMembership(fetcher, config);
            }
        }
        throw new ConfigurationException("Invalid electorate membership strategy value '" + strategy + "'");
    }
}

