/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db;

import com.google.inject.Inject;
import java.util.Map;
import org.apache.cassandra.sidecar.common.request.Service;
import org.apache.cassandra.sidecar.db.CdcConfigAccessor;
import org.apache.cassandra.sidecar.db.ConfigAccessor;
import org.apache.cassandra.sidecar.db.KafkaConfigAccessor;

public class ConfigAccessorFactory {
    private final Map<Service, ConfigAccessor> configAccessors;

    @Inject
    public ConfigAccessorFactory(KafkaConfigAccessor kafkaConfigAccessor, CdcConfigAccessor cdcConfigAccessor) {
        this.configAccessors = Map.of(Service.KAFKA, kafkaConfigAccessor, Service.CDC, cdcConfigAccessor);
    }

    public ConfigAccessor configAccessor(Service service) {
        ConfigAccessor configAccessor = this.configAccessors.get(service);
        if (configAccessor == null) {
            throw new RuntimeException("Couldn't find a db accessor for service " + service);
        }
        return configAccessor;
    }
}

