/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.keycache;

import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.io.sstable.AbstractMetricsProviders;
import org.apache.cassandra.io.sstable.GaugeProvider;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.keycache.KeyCacheSupport;

public class KeyCacheMetrics<R extends SSTableReader>
extends AbstractMetricsProviders<R> {
    public static final KeyCacheMetrics<?> instance = new KeyCacheMetrics();
    private final GaugeProvider<Double> keyCacheHitRate = this.newGaugeProvider("KeyCacheHitRate", readers -> {
        long hits = 0L;
        long requests = 0L;
        for (SSTableReader sstable : readers) {
            hits += ((KeyCacheSupport)((Object)sstable)).getKeyCache().getHits();
            requests += ((KeyCacheSupport)((Object)sstable)).getKeyCache().getRequests();
        }
        return (double)hits / (double)Math.max(1L, requests);
    });
    private final List<GaugeProvider<?>> gaugeProviders = Arrays.asList(this.keyCacheHitRate);

    @Override
    protected R map(SSTableReader r) {
        if (r instanceof KeyCacheSupport) {
            return (R)r;
        }
        return null;
    }

    public List<GaugeProvider<?>> getGaugeProviders() {
        return this.gaugeProviders;
    }
}

