/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import org.apache.cassandra.dht.Token;

abstract class ComparableObjectToken<C extends Comparable<C>>
extends Token {
    private static final long serialVersionUID = 1L;
    final C token;

    protected ComparableObjectToken(C token) {
        this.token = token;
    }

    public C getTokenValue() {
        return this.token;
    }

    public String toString() {
        return this.token.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.token.equals(((ComparableObjectToken)obj).token);
    }

    public int hashCode() {
        return this.token.hashCode();
    }

    @Override
    public int compareTo(Token o) {
        if (o.getClass() != this.getClass()) {
            throw new IllegalArgumentException("Invalid type of Token.compareTo() argument.");
        }
        return this.token.compareTo(((ComparableObjectToken)o).token);
    }

    @Override
    public double size(Token next) {
        throw new UnsupportedOperationException(String.format("Token type %s does not support token allocation.", this.getClass().getSimpleName()));
    }

    @Override
    public Token nextValidToken() {
        throw new UnsupportedOperationException(String.format("Token type %s does not support token allocation.", this.getClass().getSimpleName()));
    }
}

