/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.calcite.avatica.metrics.dropwizard;

import org.apache.calcite.avatica.metrics.Gauge;

import org.junit.Test;

import java.util.concurrent.atomic.AtomicLong;

import static org.junit.Assert.assertEquals;

/**
 * Test class for {@link DropwizardGauge}.
 */
public class DropwizardGaugeTest {

  @Test public void test() {
    SimpleGauge gauge = new SimpleGauge();
    DropwizardGauge<Long> dwGauge = new DropwizardGauge<>(gauge);

    assertEquals(gauge.getValue(), dwGauge.getValue());

    gauge.setValue(1000L);

    assertEquals(gauge.getValue(), dwGauge.getValue());
  }

  /**
   * Gauge implementation with a setter.
   */
  private static class SimpleGauge implements Gauge<Long> {

    private final AtomicLong value = new AtomicLong(0L);

    @Override public Long getValue() {
      return this.value.get();
    }

    public void setValue(long value) {
      this.value.set(value);
    }
  }
}

// End DropwizardGaugeTest.java
