/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Destroyable;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.ProvKey;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProvSecretKeySpec
extends SecretKeySpec
implements Destroyable,
ProvKey<SymmetricKey> {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private static final long serialVersionUID = -1861292622640337039L;
    private transient ValidatedSymmetricKey baseKey;

    public ProvSecretKeySpec(ValidatedSymmetricKey validatedSymmetricKey) {
        this(validatedSymmetricKey, Utils.getBaseName(validatedSymmetricKey.getAlgorithm()));
    }

    public ProvSecretKeySpec(ValidatedSymmetricKey validatedSymmetricKey, String string) {
        super(validatedSymmetricKey.getKeyBytes(), string);
        this.baseKey = validatedSymmetricKey;
    }

    @Override
    public SymmetricKey getBaseKey() {
        KeyUtil.checkDestroyed(this);
        return new SymmetricSecretKey(this.baseKey.getAlgorithm(), this.baseKey.getKeyBytes());
    }

    @Override
    public String getAlgorithm() {
        KeyUtil.checkDestroyed(this);
        return super.getAlgorithm();
    }

    @Override
    public String getFormat() {
        KeyUtil.checkDestroyed(this);
        return "RAW";
    }

    @Override
    public byte[] getEncoded() {
        KeyUtil.checkDestroyed(this);
        return Arrays.clone(this.baseKey.getKeyBytes());
    }

    @Override
    public void destroy() {
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            this.baseKey = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.hasBeenDestroyed.get();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Algorithm algorithm = (Algorithm)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new ValidatedSymmetricKey(algorithm, byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.isDestroyed()) {
            throw new IOException("key has been destroyed");
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.baseKey.getAlgorithm());
        objectOutputStream.writeObject(this.getEncoded());
    }
}

