/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.client.HostProvider;
import org.apache.zookeeper.client.StaticHostProvider;
import org.apache.zookeeper.common.Time;
import org.burningwave.tools.net.DefaultHostResolver;
import org.burningwave.tools.net.HostResolutionRequestInterceptor;
import org.burningwave.tools.net.HostResolver;
import org.burningwave.tools.net.MappedHostResolver;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class StaticHostProviderTest
extends ZKTestCase {
    private Random r = new Random(1L);
    private final double slackPercent = 10.0;
    private final int numClients = 10000;

    @BeforeAll
    public static void setupDNSMocks() {
        LinkedHashMap<String, String> hostAliases = new LinkedHashMap<String, String>();
        hostAliases.put("site1.mock", "192.168.1.1");
        hostAliases.put("site2.mock", "192.168.1.2");
        hostAliases.put("site3.mock", "192.168.1.3");
        hostAliases.put("site4.mock", "192.168.1.4");
        HostResolutionRequestInterceptor.INSTANCE.install(new HostResolver[]{new MappedHostResolver(hostAliases), DefaultHostResolver.INSTANCE});
    }

    @AfterAll
    public static void clearDNSMocks() {
        HostResolutionRequestInterceptor.INSTANCE.uninstall();
    }

    @Test
    public void testNextGoesRound() {
        StaticHostProvider hostProvider = this.getHostProvider((byte)2);
        InetSocketAddress first = hostProvider.next(0L);
        Assertions.assertTrue((first != null ? 1 : 0) != 0);
        hostProvider.next(0L);
        Assertions.assertEquals((Object)first, (Object)hostProvider.next(0L));
    }

    @Test
    public void testNextGoesRoundAndSleeps() {
        byte size;
        StaticHostProvider hostProvider = this.getHostProvider(size);
        for (size = 2; size > 0; size = (byte)(size - 1)) {
            hostProvider.next(0L);
        }
        long start = Time.currentElapsedTime();
        hostProvider.next(1000L);
        long stop = Time.currentElapsedTime();
        Assertions.assertTrue((900L <= stop - start ? 1 : 0) != 0);
    }

    @Test
    public void testNextDoesNotSleepForZero() {
        byte size;
        StaticHostProvider hostProvider = this.getHostProvider(size);
        for (size = 2; size > 0; size = (byte)(size - 1)) {
            hostProvider.next(0L);
        }
        long start = Time.currentElapsedTime();
        hostProvider.next(0L);
        long stop = Time.currentElapsedTime();
        Assertions.assertTrue((5L > stop - start ? 1 : 0) != 0);
    }

    @Test
    public void testEmptyServerAddressesList() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            StaticHostProvider hp = new StaticHostProvider(new ArrayList());
        });
    }

    @Test
    public void testInvalidHostAddresses() {
        ArrayList<InetSocketAddress> invalidAddresses = new ArrayList<InetSocketAddress>();
        InetSocketAddress unresolved = InetSocketAddress.createUnresolved("a", 1234);
        invalidAddresses.add(unresolved);
        StaticHostProvider.Resolver resolver = new StaticHostProvider.Resolver(){

            public InetAddress[] getAllByName(String name) throws UnknownHostException {
                throw new UnknownHostException();
            }
        };
        StaticHostProvider sp = new StaticHostProvider(invalidAddresses, resolver);
        InetSocketAddress n1 = sp.next(0L);
        Assertions.assertTrue((boolean)n1.isUnresolved(), (String)"Provider should return unresolved address is host is unresolvable");
        Assertions.assertSame((Object)unresolved, (Object)n1, (String)"Provider should return original address is host is unresolvable");
    }

    @Test
    public void testTwoConsequitiveCallsToNextReturnDifferentElement() {
        StaticHostProvider hostProvider = this.getHostProvider((byte)2);
        Assertions.assertNotSame((Object)hostProvider.next(0L), (Object)hostProvider.next(0L));
    }

    @Test
    public void testOnConnectDoesNotReset() {
        StaticHostProvider hostProvider = this.getHostProvider((byte)2);
        InetSocketAddress first = hostProvider.next(0L);
        hostProvider.onConnected();
        InetSocketAddress second = hostProvider.next(0L);
        Assertions.assertNotSame((Object)first, (Object)second);
    }

    @Test
    public void testUpdateClientMigrateOrNot() throws UnknownHostException {
        StaticHostProvider hostProvider = this.getHostProvider((byte)4);
        Collection<InetSocketAddress> newList = this.getServerAddresses((byte)3);
        InetSocketAddress myServer = new InetSocketAddress(InetAddress.getByAddress(new byte[]{10, 10, 10, 3}), 1237);
        boolean disconnectRequired = hostProvider.updateServerList(newList, myServer);
        Assertions.assertFalse((boolean)disconnectRequired);
        hostProvider.onConnected();
        disconnectRequired = hostProvider.updateServerList(newList, myServer);
        Assertions.assertFalse((boolean)disconnectRequired);
        hostProvider.onConnected();
        newList = this.getServerAddresses((byte)2);
        disconnectRequired = hostProvider.updateServerList(newList, myServer);
        Assertions.assertTrue((boolean)disconnectRequired);
        hostProvider.onConnected();
        disconnectRequired = hostProvider.updateServerList(newList, myServer);
        Assertions.assertTrue((boolean)disconnectRequired);
        hostProvider.onConnected();
        newList = new ArrayList<InetSocketAddress>(3);
        for (byte i = 4; i > 1; i = (byte)((byte)(i - 1))) {
            newList.add(new InetSocketAddress(InetAddress.getByAddress(new byte[]{10, 10, 10, i}), 1234 + i));
        }
        myServer = new InetSocketAddress(InetAddress.getByAddress(new byte[]{10, 10, 10, 1}), 1235);
        disconnectRequired = hostProvider.updateServerList(newList, myServer);
        Assertions.assertTrue((boolean)disconnectRequired);
        hostProvider.onConnected();
        HostProvider[] hostProviderArray = new HostProvider[10000];
        newList = this.getServerAddresses((byte)10);
        int numDisconnects = 0;
        for (int i = 0; i < 10000; ++i) {
            hostProviderArray[i] = this.getHostProvider((byte)9);
            disconnectRequired = hostProviderArray[i].updateServerList(newList, myServer);
            if (!disconnectRequired) continue;
            ++numDisconnects;
        }
        hostProvider.onConnected();
        Assertions.assertTrue(((double)numDisconnects < this.upperboundCPS(10000, 10) ? 1 : 0) != 0);
    }

    @Test
    public void testUpdateMigrationGoesRound() throws UnknownHostException {
        InetSocketAddress addr;
        int i;
        StaticHostProvider hostProvider = this.getHostProvider((byte)4);
        ArrayList<InetSocketAddress> newList = new ArrayList<InetSocketAddress>(10);
        for (byte i2 = 12; i2 > 2; i2 = (byte)((byte)(i2 - 1))) {
            newList.add(new InetSocketAddress(InetAddress.getByAddress(new byte[]{10, 10, 10, i2}), 1234 + i2));
        }
        ArrayList<InetSocketAddress> oldStaying = new ArrayList<InetSocketAddress>(2);
        for (byte i3 = 4; i3 > 2; i3 = (byte)((byte)(i3 - 1))) {
            oldStaying.add(new InetSocketAddress(InetAddress.getByAddress(new byte[]{10, 10, 10, i3}), 1234 + i3));
        }
        ArrayList<InetSocketAddress> newComing = new ArrayList<InetSocketAddress>(10);
        for (byte i4 = 12; i4 > 4; i4 = (byte)((byte)(i4 - 1))) {
            newComing.add(new InetSocketAddress(InetAddress.getByAddress(new byte[]{10, 10, 10, i4}), 1234 + i4));
        }
        boolean disconnectRequired = hostProvider.updateServerList(newList, new InetSocketAddress(InetAddress.getByAddress(new byte[]{10, 10, 10, 1}), 1235));
        Assertions.assertTrue((boolean)disconnectRequired);
        ArrayList<InetSocketAddress> seen = new ArrayList<InetSocketAddress>();
        for (i = 0; i < newComing.size(); ++i) {
            addr = hostProvider.next(0L);
            Assertions.assertTrue((boolean)newComing.contains(addr));
            Assertions.assertTrue((!seen.contains(addr) ? 1 : 0) != 0);
            seen.add(addr);
        }
        seen.clear();
        for (i = 0; i < oldStaying.size(); ++i) {
            addr = hostProvider.next(0L);
            Assertions.assertTrue((boolean)oldStaying.contains(addr));
            Assertions.assertTrue((!seen.contains(addr) ? 1 : 0) != 0);
            seen.add(addr);
        }
        InetSocketAddress first = hostProvider.next(0L);
        Assertions.assertTrue((first != null ? 1 : 0) != 0);
        for (int i5 = 0; i5 < newList.size() - 1; ++i5) {
            hostProvider.next(0L);
        }
        Assertions.assertEquals((Object)first, (Object)hostProvider.next(0L));
        hostProvider.onConnected();
    }

    @Test
    public void testUpdateLoadBalancing() throws UnknownHostException {
        boolean disconnectRequired;
        byte i;
        int i2;
        HostProvider[] hostProviderArray = new HostProvider[10000];
        InetSocketAddress[] curHostForEachClient = new InetSocketAddress[10000];
        int[] numClientsPerHost = new int[9];
        for (i2 = 0; i2 < 10000; ++i2) {
            hostProviderArray[i2] = this.getHostProvider((byte)9);
            curHostForEachClient[i2] = hostProviderArray[i2].next(0L);
            int n = curHostForEachClient[i2].getPort() - 1235;
            numClientsPerHost[n] = numClientsPerHost[n] + 1;
            hostProviderArray[i2].onConnected();
        }
        for (i2 = 0; i2 < 9; ++i2) {
            Assertions.assertTrue(((double)numClientsPerHost[i2] <= this.upperboundCPS(10000, 9) ? 1 : 0) != 0);
            Assertions.assertTrue(((double)numClientsPerHost[i2] >= this.lowerboundCPS(10000, 9) ? 1 : 0) != 0);
            numClientsPerHost[i2] = 0;
        }
        Collection<InetSocketAddress> newList = this.getServerAddresses((byte)8);
        for (i = 0; i < 10000; ++i) {
            disconnectRequired = hostProviderArray[i].updateServerList(newList, curHostForEachClient[i]);
            if (disconnectRequired) {
                curHostForEachClient[i] = hostProviderArray[i].next(0L);
            }
            int n = curHostForEachClient[i].getPort() - 1235;
            numClientsPerHost[n] = numClientsPerHost[n] + 1;
            hostProviderArray[i].onConnected();
        }
        for (i = 0; i < 8; ++i) {
            Assertions.assertTrue(((double)numClientsPerHost[i] <= this.upperboundCPS(10000, 8) ? 1 : 0) != 0);
            Assertions.assertTrue(((double)numClientsPerHost[i] >= this.lowerboundCPS(10000, 8) ? 1 : 0) != 0);
            numClientsPerHost[i] = 0;
        }
        Assertions.assertTrue((numClientsPerHost[8] == 0 ? 1 : 0) != 0);
        newList = this.getServerAddresses((byte)6);
        for (i = 0; i < 10000; ++i) {
            disconnectRequired = hostProviderArray[i].updateServerList(newList, curHostForEachClient[i]);
            if (disconnectRequired) {
                curHostForEachClient[i] = hostProviderArray[i].next(0L);
            }
            int n = curHostForEachClient[i].getPort() - 1235;
            numClientsPerHost[n] = numClientsPerHost[n] + 1;
            hostProviderArray[i].onConnected();
        }
        for (i = 0; i < 6; ++i) {
            Assertions.assertTrue(((double)numClientsPerHost[i] <= this.upperboundCPS(10000, 6) ? 1 : 0) != 0);
            Assertions.assertTrue(((double)numClientsPerHost[i] >= this.lowerboundCPS(10000, 6) ? 1 : 0) != 0);
            numClientsPerHost[i] = 0;
        }
        Assertions.assertTrue((numClientsPerHost[6] == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((numClientsPerHost[7] == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((numClientsPerHost[8] == 0 ? 1 : 0) != 0);
        newList = new ArrayList<InetSocketAddress>(8);
        for (i = 9; i > 1; i = (byte)((byte)(i - 1))) {
            newList.add(new InetSocketAddress(InetAddress.getByAddress(new byte[]{10, 10, 10, i}), 1234 + i));
        }
        for (i = 0; i < 10000; ++i) {
            disconnectRequired = hostProviderArray[i].updateServerList(newList, curHostForEachClient[i]);
            if (disconnectRequired) {
                curHostForEachClient[i] = hostProviderArray[i].next(0L);
            }
            int n = curHostForEachClient[i].getPort() - 1235;
            numClientsPerHost[n] = numClientsPerHost[n] + 1;
            hostProviderArray[i].onConnected();
        }
        Assertions.assertTrue((numClientsPerHost[0] == 0 ? 1 : 0) != 0);
        for (i = 1; i < 9; ++i) {
            Assertions.assertTrue(((double)numClientsPerHost[i] <= this.upperboundCPS(10000, 8) ? 1 : 0) != 0);
            Assertions.assertTrue(((double)numClientsPerHost[i] >= this.lowerboundCPS(10000, 8) ? 1 : 0) != 0);
            numClientsPerHost[i] = 0;
        }
        newList = this.getServerAddresses((byte)9);
        for (i = 0; i < 10000; ++i) {
            disconnectRequired = hostProviderArray[i].updateServerList(newList, curHostForEachClient[i]);
            if (disconnectRequired) {
                curHostForEachClient[i] = hostProviderArray[i].next(0L);
            }
            int n = curHostForEachClient[i].getPort() - 1235;
            numClientsPerHost[n] = numClientsPerHost[n] + 1;
            hostProviderArray[i].onConnected();
        }
        for (i = 0; i < 9; ++i) {
            Assertions.assertTrue(((double)numClientsPerHost[i] <= this.upperboundCPS(10000, 9) ? 1 : 0) != 0);
            Assertions.assertTrue(((double)numClientsPerHost[i] >= this.lowerboundCPS(10000, 9) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNoCurrentHostDuringNormalMode() throws UnknownHostException {
        boolean disconnectRequired;
        int i;
        StaticHostProvider[] hostProviderArray = new StaticHostProvider[10000];
        InetSocketAddress[] curHostForEachClient = new InetSocketAddress[10000];
        int[] numClientsPerHost = new int[9];
        for (int i2 = 0; i2 < 10000; ++i2) {
            hostProviderArray[i2] = this.getHostProvider((byte)9);
            curHostForEachClient[i2] = i2 >= 5000 ? hostProviderArray[i2].next(0L) : null;
        }
        Collection<InetSocketAddress> newList = this.getServerAddresses((byte)7);
        for (i = 0; i < 10000; ++i) {
            disconnectRequired = hostProviderArray[i].updateServerList(newList, curHostForEachClient[i]);
            if (disconnectRequired) {
                curHostForEachClient[i] = hostProviderArray[i].next(0L);
            } else if (curHostForEachClient[i] == null) {
                curHostForEachClient[i] = hostProviderArray[i].getServerAtIndex(0);
            }
            int n = curHostForEachClient[i].getPort() - 1235;
            numClientsPerHost[n] = numClientsPerHost[n] + 1;
            hostProviderArray[i].onConnected();
        }
        for (i = 0; i < 7; ++i) {
            Assertions.assertTrue(((double)numClientsPerHost[i] <= this.upperboundCPS(10000, 7) ? 1 : 0) != 0);
            Assertions.assertTrue(((double)numClientsPerHost[i] >= this.lowerboundCPS(10000, 7) ? 1 : 0) != 0);
            numClientsPerHost[i] = 0;
        }
        Assertions.assertTrue((numClientsPerHost[7] == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((numClientsPerHost[8] == 0 ? 1 : 0) != 0);
        newList = this.getServerAddresses((byte)8);
        for (i = 0; i < 10000; ++i) {
            InetSocketAddress myServer = i < 5000 ? null : curHostForEachClient[i];
            disconnectRequired = hostProviderArray[i].updateServerList(newList, myServer);
            if (disconnectRequired) {
                curHostForEachClient[i] = hostProviderArray[i].next(0L);
            }
            int n = curHostForEachClient[i].getPort() - 1235;
            numClientsPerHost[n] = numClientsPerHost[n] + 1;
            hostProviderArray[i].onConnected();
        }
        for (i = 0; i < 8; ++i) {
            Assertions.assertTrue(((double)numClientsPerHost[i] <= this.upperboundCPS(10000, 8) ? 1 : 0) != 0);
            Assertions.assertTrue(((double)numClientsPerHost[i] >= this.lowerboundCPS(10000, 8) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testReconfigDuringReconfigMode() throws UnknownHostException {
        int i;
        StaticHostProvider[] hostProviderArray = new StaticHostProvider[10000];
        InetSocketAddress[] curHostForEachClient = new InetSocketAddress[10000];
        int[] numClientsPerHost = new int[9];
        for (int i2 = 0; i2 < 10000; ++i2) {
            hostProviderArray[i2] = this.getHostProvider((byte)9);
            curHostForEachClient[i2] = hostProviderArray[i2].next(0L);
        }
        Collection<InetSocketAddress> newList = this.getServerAddresses((byte)7);
        for (i = 0; i < 10000; ++i) {
            hostProviderArray[i].updateServerList(newList, curHostForEachClient[i]);
        }
        newList = this.getServerAddresses((byte)9);
        for (i = 0; i < 10000; ++i) {
            InetSocketAddress myServer = i < 5000 ? null : curHostForEachClient[i];
            boolean disconnectRequired = hostProviderArray[i].updateServerList(newList, myServer);
            curHostForEachClient[i] = disconnectRequired ? hostProviderArray[i].next(0L) : hostProviderArray[i].getServerAtCurrentIndex();
            int n = curHostForEachClient[i].getPort() - 1235;
            numClientsPerHost[n] = numClientsPerHost[n] + 1;
            hostProviderArray[i].onConnected();
        }
        for (i = 0; i < 9; ++i) {
            Assertions.assertTrue(((double)numClientsPerHost[i] <= this.upperboundCPS(10000, 9) ? 1 : 0) != 0);
            Assertions.assertTrue(((double)numClientsPerHost[i] >= this.lowerboundCPS(10000, 9) ? 1 : 0) != 0);
        }
    }

    private StaticHostProvider getHostProvider(byte size) {
        return new StaticHostProvider(this.getServerAddresses(size), this.r.nextLong());
    }

    private Collection<InetSocketAddress> getServerAddresses(byte size) {
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>(size);
        while (size > 0) {
            try {
                list.add(new InetSocketAddress(InetAddress.getByAddress(new byte[]{10, 10, 10, size}), 1234 + size));
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            size = (byte)(size - 1);
        }
        return list;
    }

    @Test
    public void testUpdateServerList_UnresolvedHostnames_NoDisconnection1() {
        StaticHostProvider hostProvider = this.getHostProviderWithUnresolvedHostnames(4);
        Collection<InetSocketAddress> newList = this.getUnresolvedHostnames(3);
        InetSocketAddress myServer = InetSocketAddress.createUnresolved("testhost-3.testdomain.com", 1237);
        boolean disconnectRequired = hostProvider.updateServerList(newList, myServer);
        Assertions.assertFalse((boolean)disconnectRequired);
        hostProvider.onConnected();
    }

    @Test
    public void testUpdateServerList_UnresolvedHostnames_NoDisconnection2() {
        StaticHostProvider hostProvider = this.getHostProviderWithUnresolvedHostnames(3);
        Collection<InetSocketAddress> newList = this.getUnresolvedHostnames(3);
        InetSocketAddress myServer = InetSocketAddress.createUnresolved("testhost-3.testdomain.com", 1237);
        boolean disconnectRequired = hostProvider.updateServerList(newList, myServer);
        Assertions.assertFalse((boolean)disconnectRequired);
        hostProvider.onConnected();
    }

    @Test
    public void testUpdateServerList_UnresolvedHostnames_Disconnection1() {
        StaticHostProvider hostProvider = this.getHostProviderWithUnresolvedHostnames(3);
        Collection<InetSocketAddress> newList = this.getUnresolvedHostnames(2);
        InetSocketAddress myServer = InetSocketAddress.createUnresolved("testhost-3.testdomain.com", 1237);
        boolean disconnectRequired = hostProvider.updateServerList(newList, myServer);
        Assertions.assertTrue((boolean)disconnectRequired);
        hostProvider.onConnected();
    }

    @Test
    public void testUpdateServerList_UnresolvedHostnames_Disconnection2() {
        StaticHostProvider hostProvider = this.getHostProviderWithUnresolvedHostnames(3);
        Collection<InetSocketAddress> newList = this.getUnresolvedHostnames(3);
        InetSocketAddress myServer = InetSocketAddress.createUnresolved("testhost-4.testdomain.com", 1237);
        boolean disconnectRequired = hostProvider.updateServerList(newList, myServer);
        Assertions.assertTrue((boolean)disconnectRequired);
        hostProvider.onConnected();
    }

    @Test
    public void testUpdateServerList_ResolvedWithUnResolvedAddress_ForceDisconnect() {
        List<InetSocketAddress> addresses = Collections.singletonList(InetSocketAddress.createUnresolved("testhost-1.resolvable.zk", 1235));
        StaticHostProvider hostProvider = new StaticHostProvider(addresses, (StaticHostProvider.Resolver)new TestResolver());
        InetSocketAddress currentHost = hostProvider.next(100L);
        MatcherAssert.assertThat((String)"CurrentHost is which the client is currently connecting to, it should be resolved", (Object)currentHost.isUnresolved(), (Matcher)Is.is((Object)false));
        InetSocketAddress replaceHost = InetSocketAddress.createUnresolved("testhost-1.resolvable.zk", 1235);
        MatcherAssert.assertThat((String)"Replace host must be unresolved in this test case", (Object)replaceHost.isUnresolved(), (Matcher)Is.is((Object)true));
        boolean disconnect = hostProvider.updateServerList(new ArrayList<InetSocketAddress>(Collections.singletonList(replaceHost)), currentHost);
        MatcherAssert.assertThat((Object)disconnect, (Matcher)Is.is((Object)false));
    }

    @Test
    public void testUpdateServerList_ResolvedWithResolvedAddress_NoDisconnect() throws UnknownHostException {
        List<InetSocketAddress> addresses = Collections.singletonList(InetSocketAddress.createUnresolved("testhost-1.resolvable.zk", 1235));
        StaticHostProvider hostProvider = new StaticHostProvider(addresses, (StaticHostProvider.Resolver)new TestResolver());
        InetSocketAddress currentHost = hostProvider.next(100L);
        MatcherAssert.assertThat((String)"CurrentHost is which the client is currently connecting to, it should be resolved", (Object)currentHost.isUnresolved(), (Matcher)Is.is((Object)false));
        InetSocketAddress replaceHost = new InetSocketAddress(InetAddress.getByAddress(currentHost.getHostString(), currentHost.getAddress().getAddress()), currentHost.getPort());
        MatcherAssert.assertThat((String)"Replace host must be resolved in this test case", (Object)replaceHost.isUnresolved(), (Matcher)Is.is((Object)false));
        boolean disconnect = hostProvider.updateServerList(new ArrayList<InetSocketAddress>(Collections.singletonList(replaceHost)), currentHost);
        MatcherAssert.assertThat((Object)disconnect, (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void testUpdateServerList_UnResolvedWithUnResolvedAddress_ForceDisconnect() {
        List<InetSocketAddress> addresses = Collections.singletonList(InetSocketAddress.createUnresolved("testhost-1.zookeepertest.zk", 1235));
        StaticHostProvider hostProvider = new StaticHostProvider(addresses, (StaticHostProvider.Resolver)new TestResolver());
        InetSocketAddress currentHost = hostProvider.next(100L);
        MatcherAssert.assertThat((String)"CurrentHost is not resolvable in this test case", (Object)currentHost.isUnresolved(), (Matcher)Is.is((Object)true));
        InetSocketAddress replaceHost = InetSocketAddress.createUnresolved("testhost-1.resolvable.zk", 1235);
        MatcherAssert.assertThat((String)"Replace host must be unresolved in this test case", (Object)replaceHost.isUnresolved(), (Matcher)Is.is((Object)true));
        boolean disconnect = hostProvider.updateServerList(new ArrayList<InetSocketAddress>(Collections.singletonList(replaceHost)), currentHost);
        MatcherAssert.assertThat((Object)disconnect, (Matcher)Is.is((Object)true));
    }

    @Test
    public void testUpdateServerList_UnResolvedWithResolvedAddress_ForceDisconnect() throws UnknownHostException {
        List<InetSocketAddress> addresses = Collections.singletonList(InetSocketAddress.createUnresolved("testhost-1.zookeepertest.zk", 1235));
        StaticHostProvider hostProvider = new StaticHostProvider(addresses, (StaticHostProvider.Resolver)new TestResolver());
        InetSocketAddress currentHost = hostProvider.next(100L);
        MatcherAssert.assertThat((String)"CurrentHost not resolvable in this test case", (Object)currentHost.isUnresolved(), (Matcher)Is.is((Object)true));
        byte[] addr = new byte[]{10, 0, 0, 1};
        InetSocketAddress replaceHost = new InetSocketAddress(InetAddress.getByAddress(currentHost.getHostString(), addr), currentHost.getPort());
        MatcherAssert.assertThat((String)"Replace host must be resolved in this test case", (Object)replaceHost.isUnresolved(), (Matcher)Is.is((Object)false));
        boolean disconnect = hostProvider.updateServerList(new ArrayList<InetSocketAddress>(Collections.singletonList(replaceHost)), currentHost);
        MatcherAssert.assertThat((Object)disconnect, (Matcher)CoreMatchers.equalTo((Object)false));
    }

    private double lowerboundCPS(int numClients, int numServers) {
        return 0.9 * (double)numClients / (double)numServers;
    }

    private double upperboundCPS(int numClients, int numServers) {
        return 1.1 * (double)numClients / (double)numServers;
    }

    @Test
    public void testLiteralIPNoReverseNS() {
        int size = 30;
        StaticHostProvider hostProvider = this.getHostProviderUnresolved((byte)size);
        for (int i = 0; i < size; ++i) {
            InetSocketAddress next = hostProvider.next(0L);
            MatcherAssert.assertThat((Object)next, (Matcher)CoreMatchers.instanceOf(InetSocketAddress.class));
            Assertions.assertFalse((boolean)next.isUnresolved());
            Assertions.assertTrue((boolean)next.toString().startsWith("/"));
            String hostname = next.getHostString();
            Assertions.assertEquals((Object)next.getAddress().getHostAddress(), (Object)hostname);
        }
    }

    @Test
    public void testReResolvingSingle() throws UnknownHostException {
        int size = 1;
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>(size);
        list.add(InetSocketAddress.createUnresolved("issues.apache.org", 1234));
        final InetAddress issuesApacheOrg = InetAddress.getByName("site1.mock");
        StaticHostProvider.Resolver resolver = new StaticHostProvider.Resolver(){

            public InetAddress[] getAllByName(String name) {
                return new InetAddress[]{issuesApacheOrg};
            }
        };
        StaticHostProvider.Resolver spyResolver = (StaticHostProvider.Resolver)Mockito.spy((Object)resolver);
        StaticHostProvider hostProvider = new StaticHostProvider(list, spyResolver);
        for (int i = 0; i < 10; ++i) {
            InetSocketAddress next = hostProvider.next(0L);
            Assertions.assertEquals((Object)issuesApacheOrg, (Object)next.getAddress());
        }
        ((StaticHostProvider.Resolver)Mockito.verify((Object)spyResolver, (VerificationMode)Mockito.times((int)10))).getAllByName("issues.apache.org");
    }

    @Test
    public void testReResolvingMultiple() throws UnknownHostException {
        int size = 1;
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>(size);
        list.add(InetSocketAddress.createUnresolved("www.apache.org", 1234));
        InetAddress apacheOrg1 = InetAddress.getByName("site1.mock");
        InetAddress apacheOrg2 = InetAddress.getByName("site2.mock");
        final ArrayList<InetAddress> resolvedAddresses = new ArrayList<InetAddress>();
        resolvedAddresses.add(apacheOrg1);
        resolvedAddresses.add(apacheOrg2);
        StaticHostProvider.Resolver resolver = new StaticHostProvider.Resolver(){

            public InetAddress[] getAllByName(String name) {
                return resolvedAddresses.toArray(new InetAddress[resolvedAddresses.size()]);
            }
        };
        StaticHostProvider.Resolver spyResolver = (StaticHostProvider.Resolver)Mockito.spy((Object)resolver);
        StaticHostProvider hostProvider = new StaticHostProvider(list, spyResolver);
        Assertions.assertEquals((int)1, (int)hostProvider.size());
        for (int i = 0; i < 10; ++i) {
            InetSocketAddress next = hostProvider.next(0L);
            MatcherAssert.assertThat((String)"Bad IP address returned", (Object)next.getAddress().getHostAddress(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)apacheOrg1.getHostAddress()), CoreMatchers.equalTo((Object)apacheOrg2.getHostAddress())}));
            Assertions.assertEquals((int)1, (int)hostProvider.size());
        }
        ((StaticHostProvider.Resolver)Mockito.verify((Object)spyResolver, (VerificationMode)Mockito.times((int)10))).getAllByName("www.apache.org");
    }

    @Test
    public void testReResolveMultipleOneFailing() throws UnknownHostException {
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>();
        list.add(InetSocketAddress.createUnresolved("www.apache.org", 1234));
        ArrayList<String> ipList = new ArrayList<String>();
        final ArrayList<InetAddress> resolvedAddresses = new ArrayList<InetAddress>();
        for (int i = 0; i < 3; ++i) {
            ipList.add(String.format("192.168.1.%d", i + 1));
            InetAddress apacheOrg = InetAddress.getByName("site" + (i + 1) + ".mock");
            resolvedAddresses.add(apacheOrg);
        }
        StaticHostProvider.Resolver resolver = new StaticHostProvider.Resolver(){

            public InetAddress[] getAllByName(String name) {
                return resolvedAddresses.toArray(new InetAddress[resolvedAddresses.size()]);
            }
        };
        StaticHostProvider.Resolver spyResolver = (StaticHostProvider.Resolver)Mockito.spy((Object)resolver);
        StaticHostProvider hostProvider = new StaticHostProvider(list, spyResolver);
        InetSocketAddress resolvedFirst = hostProvider.next(0L);
        Assertions.assertFalse((boolean)resolvedFirst.isUnresolved(), (String)"HostProvider should return resolved addresses");
        MatcherAssert.assertThat((String)"Bad IP address returned", ipList, (Matcher)CoreMatchers.hasItems((Object[])new String[]{resolvedFirst.getAddress().getHostAddress()}));
        hostProvider.onConnected();
        InetSocketAddress resolvedSecond = hostProvider.next(0L);
        Assertions.assertFalse((boolean)resolvedSecond.isUnresolved(), (String)"HostProvider should return resolved addresses");
        MatcherAssert.assertThat((String)"Bad IP address returned", ipList, (Matcher)CoreMatchers.hasItems((Object[])new String[]{resolvedSecond.getAddress().getHostAddress()}));
        InetSocketAddress resolvedThird = hostProvider.next(0L);
        Assertions.assertFalse((boolean)resolvedThird.isUnresolved(), (String)"HostProvider should return resolved addresses");
        MatcherAssert.assertThat((String)"Bad IP address returned", ipList, (Matcher)CoreMatchers.hasItems((Object[])new String[]{resolvedThird.getAddress().getHostAddress()}));
        ((StaticHostProvider.Resolver)Mockito.verify((Object)spyResolver, (VerificationMode)Mockito.times((int)3))).getAllByName("www.apache.org");
    }

    @Test
    public void testEmptyResolution() throws UnknownHostException {
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>();
        list.add(InetSocketAddress.createUnresolved("www.apache.org", 1234));
        list.add(InetSocketAddress.createUnresolved("www.google.com", 1234));
        final ArrayList<InetAddress> resolvedAddresses = new ArrayList<InetAddress>();
        InetAddress apacheOrg1 = InetAddress.getByName("site1.mock");
        resolvedAddresses.add(apacheOrg1);
        StaticHostProvider.Resolver resolver = new StaticHostProvider.Resolver(){

            public InetAddress[] getAllByName(String name) {
                if ("www.apache.org".equalsIgnoreCase(name)) {
                    return resolvedAddresses.toArray(new InetAddress[resolvedAddresses.size()]);
                }
                return new InetAddress[0];
            }
        };
        StaticHostProvider.Resolver spyResolver = (StaticHostProvider.Resolver)Mockito.spy((Object)resolver);
        StaticHostProvider hostProvider = new StaticHostProvider(list, spyResolver);
        for (int i = 0; i < 10; ++i) {
            InetSocketAddress resolved = hostProvider.next(0L);
            hostProvider.onConnected();
            if (resolved.getHostName().equals("www.google.com")) {
                Assertions.assertTrue((boolean)resolved.isUnresolved(), (String)"HostProvider should return unresolved address if host is unresolvable");
                continue;
            }
            Assertions.assertFalse((boolean)resolved.isUnresolved(), (String)"HostProvider should return resolved addresses");
            Assertions.assertEquals((Object)"192.168.1.1", (Object)resolved.getAddress().getHostAddress());
        }
        ((StaticHostProvider.Resolver)Mockito.verify((Object)spyResolver, (VerificationMode)Mockito.times((int)5))).getAllByName("www.apache.org");
        ((StaticHostProvider.Resolver)Mockito.verify((Object)spyResolver, (VerificationMode)Mockito.times((int)5))).getAllByName("www.google.com");
    }

    @Test
    public void testReResolvingLocalhost() {
        int size = 2;
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>(size);
        list.add(InetSocketAddress.createUnresolved("localhost", 1234));
        list.add(InetSocketAddress.createUnresolved("localhost", 1235));
        StaticHostProvider hostProvider = new StaticHostProvider(list);
        int sizeBefore = hostProvider.size();
        InetSocketAddress next = hostProvider.next(0L);
        next = hostProvider.next(0L);
        Assertions.assertTrue((hostProvider.size() == sizeBefore ? 1 : 0) != 0, (String)("Different number of addresses in the list: " + hostProvider.size() + " (after), " + sizeBefore + " (before)"));
    }

    private StaticHostProvider getHostProviderUnresolved(byte size) {
        return new StaticHostProvider(this.getUnresolvedServerAddresses(size), this.r.nextLong());
    }

    private Collection<InetSocketAddress> getUnresolvedServerAddresses(byte size) {
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>(size);
        while (size > 0) {
            list.add(InetSocketAddress.createUnresolved("10.10.10." + size, 1234 + size));
            size = (byte)(size - 1);
        }
        return list;
    }

    private StaticHostProvider getHostProviderWithUnresolvedHostnames(int size) {
        return new StaticHostProvider(this.getUnresolvedHostnames(size), this.r.nextLong());
    }

    private Collection<InetSocketAddress> getUnresolvedHostnames(int size) {
        ArrayList<InetSocketAddress> list = new ArrayList<InetSocketAddress>(size);
        while (size > 0) {
            list.add(InetSocketAddress.createUnresolved(String.format("testhost-%d.testdomain.com", size), 1234 + size));
            --size;
        }
        System.out.println(Arrays.toString(list.toArray()));
        return list;
    }

    private class TestResolver
    implements StaticHostProvider.Resolver {
        private byte counter = 1;

        private TestResolver() {
        }

        public InetAddress[] getAllByName(String name) throws UnknownHostException {
            if (name.contains("resolvable")) {
                byte[] byArray = new byte[4];
                byArray[0] = 10;
                byArray[1] = 0;
                byArray[2] = 0;
                byte by = this.counter;
                this.counter = (byte)(by + 1);
                byArray[3] = (byte)(by % 10);
                byte[] addr = byArray;
                return new InetAddress[]{InetAddress.getByAddress(name, addr)};
            }
            throw new UnknownHostException();
        }
    }
}

