/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.stream.xop;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.axiom.om.impl.stream.xop.SizeLimitExceededException;

final class CountingOutputStream
extends OutputStream {
    private final long maxSize;
    private long size;

    CountingOutputStream(long maxSize) {
        this.maxSize = maxSize;
    }

    CountingOutputStream() {
        this(-1L);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.size += (long)len;
        this.checkSize();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.size += (long)b.length;
        this.checkSize();
    }

    @Override
    public void write(int b) throws IOException {
        ++this.size;
        this.checkSize();
    }

    private void checkSize() throws SizeLimitExceededException {
        if (this.maxSize != -1L && this.size > this.maxSize) {
            throw SizeLimitExceededException.INSTANCE;
        }
    }

    long getSize() {
        return this.size;
    }
}

