/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.feature;

import jakarta.xml.ws.WebServiceFeature;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.feature.ClientConfigurator;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.spi.BindingProvider;

public class ClientFramework {
    private static final WebServiceFeature[] ZERO_LENGTH_ARRAY = new WebServiceFeature[0];
    private Map<String, ClientConfigurator> configuratorMap = new HashMap<String, ClientConfigurator>();
    private Map<String, WebServiceFeature> featureMap = new HashMap<String, WebServiceFeature>();

    public void addConfigurator(String id, ClientConfigurator configurator) {
        this.configuratorMap.put(id, configurator);
    }

    public boolean isValid(WebServiceFeature feature) {
        if (feature == null) {
            return false;
        }
        return this.configuratorMap.containsKey(feature.getID());
    }

    public void addFeature(WebServiceFeature feature) {
        if (!this.isValid(feature)) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"invalidWSFeature", (String)feature.getID()));
        }
        this.featureMap.put(feature.getID(), feature);
    }

    public WebServiceFeature getFeature(String id) {
        return this.featureMap.get(id);
    }

    public WebServiceFeature[] getAllFeatures() {
        return this.featureMap.values().toArray(ZERO_LENGTH_ARRAY);
    }

    public void configure(MessageContext messageContext, BindingProvider provider) {
        for (WebServiceFeature feature : this.getAllFeatures()) {
            ClientConfigurator configurator = this.configuratorMap.get(feature.getID());
            configurator.configure(messageContext, provider);
        }
    }
}

