% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/driver_log.R
\name{adbc_driver_log}
\alias{adbc_driver_log}
\title{Log calls to another driver}
\usage{
adbc_driver_log()
}
\value{
An object of class 'adbc_driver_log'
}
\description{
Useful for debugging or ensuring that certain calls occur during
initialization and/or cleanup. The current logging output should not
be considered stable and may change in future releases.
}
\examples{
drv <- adbc_driver_log()
db <- adbc_database_init(drv, key = "value")
con <- adbc_connection_init(db, key = "value")
stmt <- adbc_statement_init(con, key = "value")
try(adbc_statement_execute_query(stmt))
adbc_statement_release(stmt)
adbc_connection_release(con)
adbc_database_release(db)

}
