/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import java.io.IOException;
import org.apache.activemq.artemis.utils.ProxyProtocolUtil;

public class HAProxyMessageHandler
extends ChannelInboundHandlerAdapter {
    private boolean skipProxyBytes = false;

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HAProxyMessage) {
            HAProxyMessage haProxyMessage = (HAProxyMessage)msg;
            ctx.channel().attr(ProxyProtocolUtil.PROXY_PROTOCOL_SOURCE_ADDRESS).set((Object)(haProxyMessage.sourceAddress() + ":" + Integer.toString(haProxyMessage.sourcePort())));
            ctx.channel().attr(ProxyProtocolUtil.PROXY_PROTOCOL_DESTINATION_ADDRESS).set((Object)(haProxyMessage.destinationAddress() + ":" + Integer.toString(haProxyMessage.destinationPort())));
            ctx.channel().attr(ProxyProtocolUtil.PROXY_PROTOCOL_VERSION).set((Object)haProxyMessage.protocolVersion().toString());
            this.skipProxyBytes = true;
        } else if (this.skipProxyBytes) {
            ctx.pipeline().remove((ChannelHandler)this);
            ctx.fireChannelRead((Object)((ByteBuf)msg).slice());
        } else {
            throw new IOException("Did not receive expected HAProxyMessage; instead received: " + String.valueOf(msg));
        }
    }
}

