/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import java.util.Map;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeLinkConfiguration;

public final class AMQPBridgeReceiverConfiguration
extends AMQPBridgeLinkConfiguration {
    public AMQPBridgeReceiverConfiguration(AMQPBridgeConfiguration configuration, Map<String, ?> properties) {
        super(configuration, properties);
    }

    public int getReceiverCredits() {
        Object property = this.properties.get("amqpCredits");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.configuration.getReceiverCredits();
    }

    public int getReceiverCreditsLow() {
        Object property = this.properties.get("amqpLowCredits");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.configuration.getReceiverCreditsLow();
    }

    public int getPullReceiverBatchSize() {
        Object property = this.properties.get("amqpPullConsumerCredits");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.configuration.getPullReceiverBatchSize();
    }

    public int getReceiverQuiesceTimeout() {
        Object property = this.properties.get("receiverQuiesceTimeout");
        if (property instanceof Number) {
            Number number = (Number)property;
            return number.intValue();
        }
        if (property instanceof String) {
            String string = (String)property;
            return Integer.parseInt(string);
        }
        return this.configuration.getReceiverQuiesceTimeout();
    }

    public int getAddressReceiverIdleTimeout() {
        Object property = this.properties.get("addressReceiverIdleTimeout");
        if (property instanceof Number) {
            Number number = (Number)property;
            return number.intValue();
        }
        if (property instanceof String) {
            String string = (String)property;
            return Integer.parseInt(string);
        }
        return this.configuration.getAddressReceiverIdleTimeout();
    }

    public int getQueueReceiverIdleTimeout() {
        Object property = this.properties.get("queueReceiverIdleTimeout");
        if (property instanceof Number) {
            Number number = (Number)property;
            return number.intValue();
        }
        if (property instanceof String) {
            String string = (String)property;
            return Integer.parseInt(string);
        }
        return this.configuration.getQueueReceiverIdleTimeout();
    }

    public int getLargeMessageThreshold() {
        Object property = this.properties.get("minLargeMessageSize");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.configuration.getLargeMessageThreshold();
    }

    public boolean isIgnoreSubscriptionFilters() {
        Object property = this.properties.get("ignoreQueueConsumerFilters");
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof String) {
            return Boolean.parseBoolean((String)property);
        }
        return this.configuration.isIgnoreSubscriptionFilters();
    }

    public boolean isIgnoreQueueFilters() {
        Object property = this.properties.get("ignoreQueueFilters");
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof String) {
            return Boolean.parseBoolean((String)property);
        }
        return this.configuration.isIgnoreQueueFilters();
    }

    public boolean isReceiverPriorityDisabled() {
        Object property = this.properties.get("disableReceiverPriority");
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof String) {
            return Boolean.parseBoolean((String)property);
        }
        return this.configuration.isReceiverPriorityDisabled();
    }

    public boolean isReceiverDemandTrackingDisabled() {
        Object property = this.properties.get("disableReceiverDemandTracking");
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof String) {
            return Boolean.parseBoolean((String)property);
        }
        return this.configuration.isReceiverDemandTrackingDisabled();
    }

    public boolean isPreferSharedDurableSubscriptions() {
        Object property = this.properties.get("preferSharedDurableSubscriptions");
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof String) {
            return Boolean.parseBoolean((String)property);
        }
        return this.configuration.isPreferSharedDurableSubscriptions();
    }

    public boolean isUseModifiedForTransientDeliveryErrors() {
        Object property = this.properties.get("amqpUseModifiedForTransientDeliveryErrors");
        if (property instanceof Boolean) {
            Boolean booleanValue = (Boolean)property;
            return booleanValue;
        }
        if (property instanceof String) {
            String string = (String)property;
            return Boolean.parseBoolean(string);
        }
        return this.configuration.isUseModifiedForTransientDeliveryErrors();
    }

    public boolean isDrainOnTransientDeliveryErrors() {
        Object property = this.properties.get("amqpDrainOnTransientDeliveryErrors");
        if (property instanceof Boolean) {
            Boolean booleanValue = (Boolean)property;
            return booleanValue;
        }
        if (property instanceof String) {
            String string = (String)property;
            return Boolean.parseBoolean(string);
        }
        return this.configuration.isDrainOnTransientDeliveryErrors();
    }

    public int getLinkQuiesceTimeout() {
        Object property = this.properties.get("amqpLinkQuiesceTimeout");
        if (property instanceof Number) {
            Number number = (Number)property;
            return number.intValue();
        }
        if (property instanceof String) {
            String string = (String)property;
            return Integer.parseInt(string);
        }
        return this.configuration.getLinkQuiesceTimeout();
    }
}

