/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect;

import io.netty.channel.ChannelPipeline;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionAddressType;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnection;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManager;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManagerFactory;
import org.apache.activemq.artemis.protocol.amqp.connect.AMQPBrokerConnection;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.ClientConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.SessionContext;
import org.apache.activemq.artemis.spi.core.remoting.TopologyResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPBrokerConnectionManager
implements ActiveMQComponent,
ClientConnectionLifeCycleListener {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ProtonProtocolManagerFactory protonProtocolManagerFactory;
    private final ActiveMQServer server;
    private volatile boolean started = false;
    private final Map<String, AMQPBrokerConnectConfiguration> amqpConnectionsConfig;
    private final Map<String, AMQPBrokerConnection> amqpBrokerConnections = new HashMap<String, AMQPBrokerConnection>();

    public AMQPBrokerConnectionManager(ProtonProtocolManagerFactory factory, List<AMQPBrokerConnectConfiguration> amqpConnectionsConfig, ActiveMQServer server) {
        this.amqpConnectionsConfig = amqpConnectionsConfig.stream().collect(Collectors.toMap(c -> c.getName(), Function.identity()));
        this.server = server;
        this.protonProtocolManagerFactory = factory;
    }

    public void start() throws Exception {
        if (!this.started) {
            this.started = true;
            for (AMQPBrokerConnectConfiguration configuration : this.amqpConnectionsConfig.values()) {
                this.createBrokerConnection(configuration, configuration.isAutostart());
            }
        }
    }

    public int getConfiguredConnectionsCount() {
        return this.amqpConnectionsConfig.size();
    }

    private void createBrokerConnection(AMQPBrokerConnectConfiguration configuration, boolean start) throws Exception {
        AMQPBrokerConnection amqpBrokerConnection = new AMQPBrokerConnection(this, configuration, this.protonProtocolManagerFactory, this.server);
        this.amqpBrokerConnections.put(configuration.getName(), amqpBrokerConnection);
        amqpBrokerConnection.initialize();
        if (start) {
            amqpBrokerConnection.start();
        }
    }

    public void updateConfiguration(List<AMQPBrokerConnectConfiguration> configurations) throws Exception {
        List<AMQPBrokerConnectConfiguration> updatedConfigurations = Objects.requireNonNullElse(configurations, Collections.emptyList());
        HashMap<AMQPBrokerConnectConfiguration, Boolean> newConnections = new HashMap<AMQPBrokerConnectConfiguration, Boolean>();
        for (AMQPBrokerConnectConfiguration configuration : updatedConfigurations) {
            boolean autoStart;
            AMQPBrokerConnectConfiguration previous = this.amqpConnectionsConfig.get(configuration.getName());
            if (previous != null && configuration.equals((Object)previous)) continue;
            if (previous != null && this.containsMirrorConfiguration(previous)) {
                logger.info("Skipping update of broker connection {} which contains a mirror configuration which are not reloadable.", (Object)previous.getName());
                continue;
            }
            this.amqpConnectionsConfig.put(configuration.getName(), configuration);
            AMQPBrokerConnection aMQPBrokerConnection = this.amqpBrokerConnections.remove(configuration.getName());
            boolean bl = aMQPBrokerConnection == null ? configuration.isAutostart() : (autoStart = aMQPBrokerConnection.isStarted() || configuration.isAutostart());
            if (aMQPBrokerConnection != null) {
                aMQPBrokerConnection.shutdown();
            }
            if (!this.started) continue;
            newConnections.put(configuration, autoStart);
        }
        Map brokerConfigurations = updatedConfigurations.stream().collect(Collectors.toMap(c -> c.getName(), Function.identity()));
        List removedList = this.amqpConnectionsConfig.values().stream().filter(c -> !brokerConfigurations.containsKey(c.getName())).collect(Collectors.toList());
        for (AMQPBrokerConnectConfiguration aMQPBrokerConnectConfiguration : removedList) {
            if (this.containsMirrorConfiguration(aMQPBrokerConnectConfiguration)) {
                logger.info("Skipping remove of broker connection {} which contains a mirror configuration which are not reloadable.", (Object)aMQPBrokerConnectConfiguration.getName());
                continue;
            }
            this.amqpConnectionsConfig.remove(aMQPBrokerConnectConfiguration.getName());
            AMQPBrokerConnection connection = this.amqpBrokerConnections.remove(aMQPBrokerConnectConfiguration.getName());
            if (connection == null) continue;
            connection.shutdown();
        }
        for (Map.Entry entry : newConnections.entrySet()) {
            this.createBrokerConnection((AMQPBrokerConnectConfiguration)entry.getKey(), (Boolean)entry.getValue());
        }
    }

    private boolean containsMirrorConfiguration(AMQPBrokerConnectConfiguration configuration) {
        for (AMQPBrokerConnectionElement element : configuration.getConnectionElements()) {
            if (!AMQPBrokerConnectionAddressType.MIRROR.equals((Object)element.getType())) continue;
            return true;
        }
        return false;
    }

    public void connected(NettyConnection nettyConnection, AMQPBrokerConnection bridgeConnection) {
    }

    public void stop() throws Exception {
        if (this.started) {
            this.started = false;
            try {
                for (AMQPBrokerConnection connection : this.amqpBrokerConnections.values()) {
                    connection.shutdown();
                }
            }
            finally {
                this.amqpBrokerConnections.clear();
            }
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public void connectionCreated(ActiveMQComponent component, Connection connection, ClientProtocolManager protocol) {
    }

    public void connectionDestroyed(Object connectionID, boolean failed) {
        for (AMQPBrokerConnection connection : this.amqpBrokerConnections.values()) {
            if (connection.getConnection() == null || !connectionID.equals(connection.getConnection().getID())) continue;
            connection.connectionDestroyed(connectionID, failed);
        }
    }

    public void connectionException(Object connectionID, ActiveMQException me) {
        for (AMQPBrokerConnection connection : this.amqpBrokerConnections.values()) {
            if (connection.getConnection() == null || !connectionID.equals(connection.getConnection().getID())) continue;
            connection.connectionException(connectionID, me);
        }
    }

    public void connectionReadyForWrites(Object connectionID, boolean ready) {
        for (AMQPBrokerConnection connection : this.amqpBrokerConnections.values()) {
            if (!connection.getConnection().getID().equals(connectionID)) continue;
            connection.connectionReadyForWrites(connectionID, ready);
        }
    }

    public static class ClientProtocolManagerWithAMQP
    implements ClientProtocolManager {
        public final ProtonProtocolManager protonPM;

        public ClientProtocolManagerWithAMQP(ProtonProtocolManager protonPM) {
            this.protonPM = protonPM;
        }

        public ProtonProtocolManager getProtonPM() {
            return this.protonPM;
        }

        public ClientProtocolManager setExecutor(Executor executor) {
            return null;
        }

        public RemotingConnection connect(Connection transportConnection, long callTimeout, long callFailoverTimeout, List<Interceptor> incomingInterceptors, List<Interceptor> outgoingInterceptors, TopologyResponseHandler topologyResponseHandler) {
            return null;
        }

        public RemotingConnection getCurrentConnection() {
            return null;
        }

        public Lock lockSessionCreation() {
            return null;
        }

        public boolean waitOnLatch(long milliseconds) throws InterruptedException {
            return false;
        }

        public void stop() {
        }

        public boolean isAlive() {
            return false;
        }

        public void addChannelHandlers(ChannelPipeline pipeline) {
        }

        public void sendSubscribeTopology(boolean isServer) {
        }

        public void ping(long connectionTTL) {
        }

        public SessionContext createSessionContext(String name, String username, String password, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, int minLargeMessageSize, int confirmationWindowSize, String clientID) throws ActiveMQException {
            return null;
        }

        public boolean cleanupBeforeFailover(ActiveMQException cause) {
            return false;
        }

        public boolean checkForFailover(String nodeID) throws ActiveMQException {
            return false;
        }

        public void setSessionFactory(ClientSessionFactory factory) {
        }

        public ClientSessionFactory getSessionFactory() {
            return null;
        }

        public String getName() {
            return null;
        }
    }
}

