/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.spi.RouteError;

public class DefaultRouteError
implements RouteError {
    private final RouteError.Phase phase;
    private final Throwable throwable;

    public DefaultRouteError(RouteError.Phase phase, Throwable throwable) {
        this.phase = phase;
        this.throwable = throwable;
    }

    @Override
    public RouteError.Phase getPhase() {
        return this.phase;
    }

    @Override
    public Throwable getException() {
        return this.throwable;
    }

    public String toString() {
        return "DefaultRouteError{phase=" + (Object)((Object)this.phase) + ", throwable=" + this.throwable + '}';
    }

    public static void set(CamelContext context, String routeId, RouteError.Phase phase, Throwable throwable) {
        Route route = context.getRoute(routeId);
        if (route != null) {
            route.getRouteContext().setLastError(new DefaultRouteError(phase, throwable));
        }
    }

    public static void reset(CamelContext context, String routeId) {
        Route route = context.getRoute(routeId);
        if (route != null) {
            route.getRouteContext().setLastError(null);
        }
    }
}

