/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.namespace.create;

import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.manager.tableOps.namespace.create.FinishCreateNamespace;
import org.apache.accumulo.manager.tableOps.namespace.create.NamespaceInfo;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.store.NamespacePropKey;
import org.apache.accumulo.server.conf.store.PropStoreKey;
import org.apache.accumulo.server.tables.TableManager;
import org.apache.accumulo.server.util.PropUtil;

class PopulateZookeeperWithNamespace
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private final NamespaceInfo namespaceInfo;

    PopulateZookeeperWithNamespace(NamespaceInfo ti) {
        this.namespaceInfo = ti;
    }

    @Override
    public long isReady(long id, Manager environment) throws Exception {
        return Utils.reserveNamespace(environment, this.namespaceInfo.namespaceId, id, true, false, TableOperation.CREATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Manager> call(long tid, Manager manager) throws Exception {
        Utils.getTableNameLock().lock();
        try {
            Utils.checkNamespaceDoesNotExist(manager.getContext(), this.namespaceInfo.namespaceName, this.namespaceInfo.namespaceId, TableOperation.CREATE);
            TableManager.prepareNewNamespaceState((ServerContext)manager.getContext(), (NamespaceId)this.namespaceInfo.namespaceId, (String)this.namespaceInfo.namespaceName, (ZooUtil.NodeExistsPolicy)ZooUtil.NodeExistsPolicy.OVERWRITE);
            PropUtil.setProperties((ServerContext)manager.getContext(), (PropStoreKey)NamespacePropKey.of((ServerContext)manager.getContext(), (NamespaceId)this.namespaceInfo.namespaceId), this.namespaceInfo.props);
            manager.getContext().clearTableListCache();
            FinishCreateNamespace finishCreateNamespace = new FinishCreateNamespace(this.namespaceInfo);
            return finishCreateNamespace;
        }
        finally {
            Utils.getTableNameLock().unlock();
        }
    }

    @Override
    public void undo(long tid, Manager manager) throws Exception {
        manager.getTableManager().removeNamespace(this.namespaceInfo.namespaceId);
        manager.getContext().clearTableListCache();
        Utils.unreserveNamespace(manager, this.namespaceInfo.namespaceId, tid, true);
    }
}

